/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractIntProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;

public final class VGapProperty
extends AbstractIntProperty<RadContainer> {
    public static VGapProperty getInstance(Project project) {
        return (VGapProperty)ServiceManager.getService((Project)project, VGapProperty.class);
    }

    public VGapProperty() {
        super(null, "Vertical Gap", -1);
    }

    @Override
    public Integer getValue(RadContainer component) {
        if (component.getLayout() instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)component.getLayout();
            return layout.getVgap();
        }
        if (component.getLayout() instanceof FlowLayout) {
            FlowLayout layout = (FlowLayout)component.getLayout();
            return layout.getVgap();
        }
        if (component.getLayout() instanceof CardLayout) {
            CardLayout layout = (CardLayout)component.getLayout();
            return layout.getVgap();
        }
        if (component.getLayout() instanceof AbstractLayout) {
            AbstractLayout layoutManager = (AbstractLayout)component.getLayout();
            return layoutManager.getVGap();
        }
        return null;
    }

    @Override
    protected void setValueImpl(RadContainer component, Integer value) throws Exception {
        if (component.getLayout() instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)component.getLayout();
            layout.setVgap(value);
        } else if (component.getLayout() instanceof FlowLayout) {
            FlowLayout layout = (FlowLayout)component.getLayout();
            layout.setVgap(value);
        } else if (component.getLayout() instanceof CardLayout) {
            CardLayout layout = (CardLayout)component.getLayout();
            layout.setVgap(value);
        } else {
            AbstractLayout layoutManager = (AbstractLayout)component.getLayout();
            layoutManager.setVGap(value.intValue());
        }
    }

    @Override
    protected int getDefaultValue(RadContainer radContainer) {
        return HGapProperty.getDefaultGap(radContainer.getLayout());
    }
}

