/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadErrorComponent
extends RadAtomicComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.RadErrorComponent");
    private final String myComponentClassName;
    private final Element myProperties;
    private final String myErrorDescription;

    public static RadErrorComponent create(ModuleProvider module, String id, String componentClassName, Element properties, @NotNull String errorDescription) {
        if (errorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorDescription", "com/intellij/uiDesigner/radComponents/RadErrorComponent", "create"));
        }
        return new RadErrorComponent(module, id, componentClassName, properties, errorDescription);
    }

    private RadErrorComponent(ModuleProvider module, String id, @NotNull String componentClassName, @Nullable Element properties, @NotNull String errorDescription) {
        if (componentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentClassName", "com/intellij/uiDesigner/radComponents/RadErrorComponent", "<init>"));
        }
        if (errorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorDescription", "com/intellij/uiDesigner/radComponents/RadErrorComponent", "<init>"));
        }
        super(module, MyComponent.class, id);
        this.myComponentClassName = componentClassName;
        this.myErrorDescription = errorDescription;
        this.myProperties = properties;
    }

    @Override
    @NotNull
    public String getComponentClassName() {
        String string = this.myComponentClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadErrorComponent", "getComponentClassName"));
        }
        return string;
    }

    public String getErrorDescription() {
        return this.myErrorDescription;
    }

    @Override
    public void write(XmlWriter writer) {
        writer.startElement("component");
        try {
            this.writeId(writer);
            writer.addAttribute("class", this.myComponentClassName);
            this.writeBinding(writer);
            this.writeConstraints(writer);
            if (this.myProperties != null) {
                writer.writeElement(this.myProperties);
            }
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    public boolean hasIntrospectedProperties() {
        return false;
    }

    private static final class MyComponent
    extends JComponent {
        public MyComponent() {
            this.setMinimumSize(new Dimension(20, 20));
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.red);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

