/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class RecyclerViewDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("RecyclerView", "RecyclerView Problems", "`RecyclerView` will *not* call `onBindViewHolder` again when the position of the item changes in the data set unless the item itself is invalidated or the new position cannot be determined.\n\nFor this reason, you should *only* use the position parameter while acquiring the related data item inside this method, and should *not* keep a copy of it.\n\nIf you need the position of an item later on (e.g. in a click listener), use `getAdapterPosition()` which will have the updated adapter position.", Category.CORRECTNESS, 8, Severity.WARNING, new Implementation(RecyclerViewDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String VIEW_ADAPTER = "android.support.v7.widget.RecyclerView.Adapter";
    private static final String ON_BIND_VIEW_HOLDER = "onBindViewHolder";

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(VIEW_ADAPTER);
    }

    @Override
    public void checkClass(JavaContext context, ClassDeclaration declaration, Node node, JavaParser.ResolvedClass resolvedClass) {
        NormalTypeBody body;
        if (declaration != null) {
            body = declaration.astBody();
        } else if (node instanceof NormalTypeBody) {
            body = (NormalTypeBody)node;
        } else {
            return;
        }
        for (Node child : body.astMembers()) {
            int size;
            MethodDeclaration method;
            if (!(child instanceof MethodDeclaration) || !(method = (MethodDeclaration)child).astMethodName().astValue().equals(ON_BIND_VIEW_HOLDER) || (size = method.astParameters().size()) != 2 && size != 3) continue;
            RecyclerViewDetector.checkMethod(context, method);
        }
    }

    private static void checkMethod(JavaContext context, MethodDeclaration declaration) {
        Iterator iterator = declaration.astParameters().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        VariableDefinition viewHolder = (VariableDefinition)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        VariableDefinition parameter = (VariableDefinition)iterator.next();
        JavaParser.ResolvedNode reference = context.resolve((Node)parameter);
        if (reference instanceof JavaParser.ResolvedVariable) {
            ParameterEscapesVisitor visitor = new ParameterEscapesVisitor(context, declaration, (JavaParser.ResolvedVariable)reference);
            declaration.accept((AstVisitor)visitor);
            if (visitor.variableEscapes()) {
                RecyclerViewDetector.reportError(context, viewHolder, parameter);
            }
        } else if (parameter.astModifiers().isFinal()) {
            RecyclerViewDetector.reportError(context, viewHolder, parameter);
        }
    }

    private static void reportError(JavaContext context, VariableDefinition viewHolder, VariableDefinition parameter) {
        VariableDefinitionEntry first = (VariableDefinitionEntry)viewHolder.astVariables().first();
        String variablePrefix = first != null ? first.astName().astValue() : "ViewHolder";
        String message = String.format("Do not treat position as fixed; only use immediately and call `%1$s.getAdapterPosition()` to look it up later", variablePrefix);
        context.report(ISSUE, (Node)parameter, context.getLocation((Node)parameter), message);
    }

    private static class ParameterEscapesVisitor
    extends ForwardingAstVisitor {
        protected final JavaContext mContext;
        protected final List<JavaParser.ResolvedVariable> mVariables;
        private final ClassDeclaration mBindClass;
        private boolean mEscapes;
        private boolean mFoundInnerClass;

        public ParameterEscapesVisitor(JavaContext context, MethodDeclaration onBindMethod, JavaParser.ResolvedVariable variable) {
            this.mContext = context;
            this.mVariables = Lists.newArrayList((Object[])new JavaParser.ResolvedVariable[]{variable});
            this.mBindClass = JavaContext.findSurroundingClass((Node)onBindMethod);
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        public boolean visitNode(Node node) {
            return this.mEscapes || super.visitNode(node);
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            JavaParser.ResolvedNode resolved;
            Expression initializer = node.astInitializer();
            if (initializer instanceof VariableReference && (resolved = this.mContext.resolve((Node)initializer)) != null && this.mVariables.contains(resolved)) {
                JavaParser.ResolvedNode resolvedVariable = this.mContext.resolve((Node)node);
                if (resolvedVariable instanceof JavaParser.ResolvedVariable) {
                    JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolvedVariable;
                    this.mVariables.add(variable);
                } else if (resolvedVariable instanceof JavaParser.ResolvedField) {
                    this.mEscapes = true;
                }
            }
            return super.visitVariableDefinitionEntry(node);
        }

        public boolean visitBinaryExpression(BinaryExpression node) {
            if (node.astOperator() == BinaryOperator.ASSIGN) {
                JavaParser.ResolvedNode resolved;
                Expression rhs = node.astRight();
                boolean clearLhs = true;
                if (rhs instanceof VariableReference && (resolved = this.mContext.resolve((Node)rhs)) != null && this.mVariables.contains(resolved)) {
                    clearLhs = false;
                    JavaParser.ResolvedNode resolvedLhs = this.mContext.resolve((Node)node.astLeft());
                    if (resolvedLhs instanceof JavaParser.ResolvedVariable) {
                        JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolvedLhs;
                        this.mVariables.add(variable);
                    } else if (resolvedLhs instanceof JavaParser.ResolvedField) {
                        this.mEscapes = true;
                    }
                }
                if (clearLhs && (resolved = this.mContext.resolve((Node)node.astLeft())) != null && this.mVariables.contains(resolved)) {
                    this.mVariables.remove(resolved);
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitVariableReference(VariableReference node) {
            JavaParser.ResolvedNode resolved;
            if (this.mFoundInnerClass && (resolved = this.mContext.resolve((Node)node)) != null && this.mVariables.contains(resolved)) {
                for (Node scope = node.getParent(); scope != null; scope = scope.getParent()) {
                    if (!(scope instanceof NormalTypeBody)) continue;
                    if (scope == this.mBindClass.astBody()) break;
                    this.mEscapes = true;
                    break;
                }
            }
            return super.visitVariableReference(node);
        }

        public boolean visitClassLiteral(ClassLiteral node) {
            this.mFoundInnerClass = true;
            return super.visitClassLiteral(node);
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            NormalTypeBody anonymous = node.astAnonymousClassBody();
            if (anonymous != null) {
                this.mFoundInnerClass = true;
            }
            return super.visitConstructorInvocation(node);
        }
    }
}

