/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TypeEvaluator;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class SecureRandomDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("SecureRandom", "Using a fixed seed with `SecureRandom`", "Specifying a fixed seed will cause the instance to return a predictable sequence of numbers. This may be useful for testing but it is not appropriate for secure use.", Category.SECURITY, 9, Severity.WARNING, new Implementation(SecureRandomDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/java/security/SecureRandom.html");
    private static final String SET_SEED = "setSeed";
    public static final String JAVA_SECURITY_SECURE_RANDOM = "java.security.SecureRandom";
    public static final String JAVA_UTIL_RANDOM = "java.util.Random";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(SET_SEED);
    }

    @Override
    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation call) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)call);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        Expression seedArgument = (Expression)call.astArguments().first();
        if (seedArgument == null) {
            return;
        }
        JavaParser.ResolvedClass containingClass = method.getContainingClass();
        if (containingClass.matches(JAVA_SECURITY_SECURE_RANDOM) || containingClass.isSubclassOf(JAVA_UTIL_RANDOM, false) && SecureRandomDetector.isSecureRandomReceiver(context, call)) {
            Object seed = ConstantEvaluator.evaluate(context, (Node)seedArgument);
            if (seed != null) {
                context.report(ISSUE, (Node)call, context.getLocation((Node)call), "Do not call `setSeed()` on a `SecureRandom` with a fixed seed: it is not secure. Use `getSeed()`.");
            } else {
                JavaParser.ResolvedMethod seedMethod;
                String methodName;
                JavaParser.ResolvedNode resolvedArgument = context.resolve((Node)seedArgument);
                if (resolvedArgument instanceof JavaParser.ResolvedMethod && ((methodName = (seedMethod = (JavaParser.ResolvedMethod)resolvedArgument).getName()).equals("currentTimeMillis") || methodName.equals("nanoTime"))) {
                    context.report(ISSUE, (Node)call, context.getLocation((Node)call), "It is dangerous to seed `SecureRandom` with the current time because that value is more predictable to an attacker than the default seed.");
                }
            }
        }
    }

    private static boolean isSecureRandomReceiver(JavaContext context, MethodInvocation call) {
        Expression operand = call.astOperand();
        return operand != null && SecureRandomDetector.isSecureRandomType(context, (Node)operand);
    }

    private static boolean isSecureRandomType(JavaContext context, Node node) {
        JavaParser.TypeDescriptor type = TypeEvaluator.evaluate(context, node);
        return type != null && type.matchesName(JAVA_SECURITY_SECURE_RANDOM);
    }
}

