/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.multiplex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class PipeInputStream
extends InputStream {
    private static final Item ITEM_CLOSE = new Item(null, 0, 0);
    private final OutputStream mSource;
    private final LinkedList<Item> mQueue = new LinkedList();
    private final Semaphore mSemaphore = new Semaphore(0);
    private final byte[] mByte = new byte[1];

    PipeInputStream() {
        this.mSource = new Writer();
    }

    public OutputStream getSource() {
        return this.mSource;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.mByte, 0, 1) > 0 ? this.mByte[0] : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        boolean closed = false;
        while (!closed && len > n) {
            try {
                this.mSemaphore.acquire();
                LinkedList<Item> linkedList = this.mQueue;
                synchronized (linkedList) {
                    Item item = this.mQueue.getFirst();
                    if (item != ITEM_CLOSE) {
                        n += item.read(b, off + n, len - n);
                        if (item.remaining() == 0) {
                            this.mQueue.removeFirst();
                        } else {
                            this.mSemaphore.release();
                        }
                    } else {
                        closed = true;
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (n == 0 && closed) {
            return -1;
        }
        return n;
    }

    private class Writer
    extends OutputStream {
        private Writer() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                LinkedList linkedList = PipeInputStream.this.mQueue;
                synchronized (linkedList) {
                    PipeInputStream.this.mQueue.addLast(new Item(b, off, len));
                }
                PipeInputStream.this.mSemaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            LinkedList linkedList = PipeInputStream.this.mQueue;
            synchronized (linkedList) {
                PipeInputStream.this.mQueue.addLast(ITEM_CLOSE);
                PipeInputStream.this.mSemaphore.release();
            }
        }
    }

    private static class Item {
        private final byte[] mData;
        private final int mCount;
        private int mOffset;

        public Item(byte[] data, int offset, int count) {
            this.mData = data;
            this.mCount = count;
            this.mOffset = offset;
        }

        public int read(byte[] out, int offset, int count) {
            int remaining = this.remaining();
            if (count > remaining) {
                count = remaining;
            }
            System.arraycopy(this.mData, this.mOffset, out, offset, count);
            this.mOffset += count;
            return count;
        }

        public int remaining() {
            return this.mCount - this.mOffset;
        }
    }
}

