/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.rpclib.schema.TypeTag;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class Slice
extends Type {
    String mAlias;
    Type mValueType;

    public Slice(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/Slice", "<init>"));
        }
        this.mValueType = Type.decode(d);
        this.mAlias = d.nonCompactString();
    }

    public Slice(String alias, Type valueType) {
        this.mAlias = alias;
        this.mValueType = valueType;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    @Override
    public void encodeValue(@NotNull Encoder e, Object value) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/Slice", "encodeValue"));
        }
        if (Primitive.isMethod(this.mValueType, Method.Uint8)) {
            assert (value instanceof byte[]);
            byte[] array = (byte[])value;
            e.uint32(array.length);
            e.write(array, array.length);
        } else {
            assert (value instanceof Object[]);
            Object[] array = (Object[])value;
            e.uint32(array.length);
            for (Object v : array) {
                this.mValueType.encodeValue(e, v);
            }
        }
    }

    @Override
    public Object decodeValue(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/Slice", "decodeValue"));
        }
        if (Primitive.isMethod(this.mValueType, Method.Uint8)) {
            byte[] array = new byte[d.uint32()];
            d.read(array, array.length);
            return array;
        }
        Object[] array = new Object[d.uint32()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.mValueType.decodeValue(d);
        }
        return array;
    }

    @Override
    public void encode(@NotNull Encoder e) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/Slice", "encode"));
        }
        TypeTag.SliceTag.encode(e);
        this.mValueType.encode(e);
        e.nonCompactString(this.mAlias);
    }

    @Override
    void name(StringBuilder out) {
        out.append("slice<");
        this.mValueType.name(out);
        out.append('>');
    }

    @Override
    public void signature(StringBuilder out) {
        out.append("[]");
        this.mValueType.signature(out);
    }
}

