/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class CommandLineWrapper {
    private static final String PREFIX = "-D";
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static void main(String[] args) throws Exception {
        File jarFile = new File(args[0]);
        MainPair mainPair = args[0].endsWith(".jar") ? CommandLineWrapper.loadMainClassFromClasspathJar(jarFile, args) : CommandLineWrapper.loadMainClassWithOldCustomLoader(jarFile, args);
        String[] mainArgs = mainPair.getArgs();
        Class mainClass = mainPair.getMainClass();
        Class<?> mainArgType = new String[0].getClass();
        Method main = mainClass.getMethod("main", mainArgType);
        CommandLineWrapper.ensureAccess(main);
        main.invoke(null, new Object[]{mainArgs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MainPair loadMainClassFromClasspathJar(File jarFile, String[] args) throws Exception {
        String[] mainArgs;
        JarInputStream inputStream = new JarInputStream(new FileInputStream(jarFile));
        try {
            String programParameters;
            Manifest manifest = inputStream.getManifest();
            String vmParams = manifest.getMainAttributes().getValue("VM-Options");
            if (vmParams != null) {
                HashMap vmOptions = new HashMap();
                CommandLineWrapper.parseVmOptions(vmParams, vmOptions);
                Iterator iterator = vmOptions.keySet().iterator();
                while (iterator.hasNext()) {
                    String optionName = (String)iterator.next();
                    System.setProperty(optionName, (String)vmOptions.get(optionName));
                }
            }
            if ((programParameters = manifest.getMainAttributes().getValue("Program-Parameters")) == null) {
                mainArgs = new String[args.length - 2];
                System.arraycopy(args, 2, mainArgs, 0, mainArgs.length);
            } else {
                mainArgs = CommandLineWrapper.splitBySpaces(programParameters);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            jarFile.deleteOnExit();
        }
        return new MainPair(Class.forName(args[1]), mainArgs);
    }

    private static String[] splitBySpaces(String parameterString) {
        parameterString = parameterString.trim();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer token = new StringBuffer(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params.toArray(new String[params.size()]);
    }

    public static void parseVmOptions(String vmParams, Map vmOptions) {
        int idx = vmParams.indexOf(PREFIX);
        while (idx >= 0) {
            String vmParamValue;
            String vmParamName;
            int indexOf = vmParams.indexOf(PREFIX, idx + PREFIX.length());
            String vmParam = indexOf < 0 ? vmParams.substring(idx) : vmParams.substring(idx, indexOf - 1);
            int eqIdx = vmParam.indexOf(61);
            if (eqIdx > -1 && eqIdx < vmParam.length() - 1) {
                vmParamName = vmParam.substring(0, eqIdx);
                vmParamValue = vmParam.substring(eqIdx + 1);
            } else {
                vmParamName = vmParam;
                vmParamValue = "";
            }
            vmOptions.put(vmParamName.trim().substring(PREFIX.length()), vmParamValue);
            idx = indexOf;
        }
    }

    private static void ensureAccess(Object reflectionObject) {
        Class<?> aClass = reflectionObject.getClass();
        try {
            Method setAccessibleMethod = aClass.getMethod("setAccessible", Boolean.TYPE);
            setAccessibleMethod.invoke(reflectionObject, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MainPair loadMainClassWithOldCustomLoader(File file, String[] args) throws Exception {
        StringBuffer buf;
        ArrayList<URL> urls;
        block13: {
            urls = new ArrayList<URL>();
            buf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            block7: while (true) {
                while (reader.ready()) {
                    String fileName = reader.readLine();
                    if (buf.length() > 0) {
                        buf.append(File.pathSeparator);
                    }
                    buf.append(fileName);
                    File classpathElement = new File(fileName);
                    try {
                        urls.add(classpathElement.toURI().toURL());
                        continue block7;
                    }
                    catch (NoSuchMethodError e) {
                        urls.add(classpathElement.toURL());
                    }
                }
                break block13;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                reader.close();
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
        System.setProperty("java.class.path", buf.toString());
        int startArgsIdx = 2;
        String mainClassName = args[startArgsIdx - 1];
        String[] mainArgs = new String[args.length - startArgsIdx];
        System.arraycopy(args, startArgsIdx, mainArgs, 0, mainArgs.length);
        for (int i = 0; i < urls.size(); ++i) {
            URL url = (URL)urls.get(i);
            urls.set(i, CommandLineWrapper.internFileProtocol(url));
        }
        ClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        String classLoader = System.getProperty("java.system.class.loader");
        if (classLoader != null) {
            try {
                loader = (ClassLoader)Class.forName(classLoader).getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CommandLineWrapper.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).newInstance(loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<?> mainClass = loader.loadClass(mainClassName);
        Thread.currentThread().setContextClassLoader(loader);
        return new MainPair(mainClass, mainArgs);
    }

    private static URL internFileProtocol(URL url) {
        try {
            if ("file".equals(url.getProtocol())) {
                return new URL("file", url.getHost(), url.getPort(), url.getFile());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MainPair {
        private Class mainClass;
        private String[] args;

        public MainPair(Class mainClass, String[] args) {
            this.mainClass = mainClass;
            this.args = args;
        }

        public Class getMainClass() {
            return this.mainClass;
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

