/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.testFrameworks.ForkedDebuggerHelper;
import com.intellij.rt.execution.testFrameworks.ForkedVMWrapper;
import com.intellij.rt.execution.testFrameworks.ProcessBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public abstract class ForkedByModuleSplitter {
    protected final ForkedDebuggerHelper myForkedDebuggerHelper = new ForkedDebuggerHelper();
    protected final String myWorkingDirsPath;
    protected final String myForkMode;
    protected final PrintStream myOut;
    protected final PrintStream myErr;
    protected final List myNewArgs;
    protected String myDynamicClasspath;
    protected List myVMParameters;

    public ForkedByModuleSplitter(String workingDirsPath, String forkMode, PrintStream out, PrintStream err, List newArgs) {
        this.myWorkingDirsPath = workingDirsPath;
        this.myForkMode = forkMode;
        this.myOut = out;
        this.myErr = err;
        this.myNewArgs = newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startSplitting(String[] args, String configName, String commandLinePath, String repeatCount) throws Exception {
        args = this.myForkedDebuggerHelper.excludeDebugPortFromArgs(args);
        this.myVMParameters = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(commandLinePath));
        this.myDynamicClasspath = bufferedReader.readLine();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.myVMParameters.add(line);
            }
        }
        finally {
            bufferedReader.close();
        }
        long time = System.currentTimeMillis();
        int result = this.startSplitting(args, configName, repeatCount);
        this.myForkedDebuggerHelper.closeDebugSocket();
        this.sendTime(time);
        return result;
    }

    protected int startChildFork(List args, File workingDir, String classpath, String repeatCount) throws IOException, InterruptedException {
        ArrayList vmParameters = new ArrayList(this.myVMParameters);
        this.myForkedDebuggerHelper.setupDebugger(vmParameters);
        File tempFile = File.createTempFile("fork", "test");
        tempFile.deleteOnExit();
        String testOutputPath = tempFile.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder();
        builder.add(vmParameters);
        builder.add("-classpath");
        if (this.myDynamicClasspath.length() > 0) {
            try {
                builder.add(ForkedByModuleSplitter.createClasspathJarFile(new Manifest(), classpath).getAbsolutePath());
            }
            catch (Throwable e) {
                builder.add(classpath);
            }
        } else {
            builder.add(classpath);
        }
        builder.add(this.getStarterName());
        builder.add(testOutputPath);
        builder.add(args);
        if (repeatCount != null) {
            builder.add(repeatCount);
        }
        builder.setWorkingDir(workingDir);
        Process exec = builder.createProcess();
        int result = exec.waitFor();
        ForkedVMWrapper.readWrapped(testOutputPath, this.myOut, this.myErr);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int splitPerModule(String repeatCount) throws IOException {
        int result = 0;
        BufferedReader perDirReader = new BufferedReader(new FileReader(this.myWorkingDirsPath));
        try {
            String workingDir;
            String packageName = perDirReader.readLine();
            while ((workingDir = perDirReader.readLine()) != null) {
                String moduleName = perDirReader.readLine();
                String classpath = perDirReader.readLine();
                try {
                    ArrayList<String> classNames = new ArrayList<String>();
                    int classNamesSize = Integer.parseInt(perDirReader.readLine());
                    for (int i = 0; i < classNamesSize; ++i) {
                        String className = perDirReader.readLine();
                        if (className == null) {
                            System.err.println("Class name is expected. Working dir: " + workingDir);
                            result = -1;
                            break;
                        }
                        classNames.add(className);
                    }
                    int childResult = this.startPerModuleFork(moduleName, classNames, packageName, workingDir, classpath, repeatCount, result);
                    result = Math.min(childResult, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            perDirReader.close();
        }
        return result;
    }

    protected abstract int startSplitting(String[] var1, String var2, String var3) throws Exception;

    protected abstract int startPerModuleFork(String var1, List var2, String var3, String var4, String var5, String var6, int var7) throws Exception;

    protected abstract String getStarterName();

    protected void sendTime(long time) {
    }

    protected void sendTree(Object rootDescription) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createClasspathJarFile(Manifest manifest, String classpath) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String classpathForManifest = "";
        int idx = 0;
        int endIdx = 0;
        while (endIdx >= 0) {
            String path;
            endIdx = classpath.indexOf(File.pathSeparator, idx);
            String string = path = endIdx < 0 ? classpath.substring(idx) : classpath.substring(idx, endIdx);
            if (classpathForManifest.length() > 0) {
                classpathForManifest = classpathForManifest + " ";
            }
            try {
                classpathForManifest = classpathForManifest + new File(path).toURI().toURL().toString();
            }
            catch (NoSuchMethodError e) {
                classpathForManifest = classpathForManifest + new File(path).toURL().toString();
            }
            idx = endIdx + File.pathSeparator.length();
        }
        attributes.put(Attributes.Name.CLASS_PATH, classpathForManifest);
        File jarFile = File.createTempFile("classpath", ".jar");
        ZipOutputStream jarPlugin = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarFile));
            jarPlugin = new JarOutputStream((OutputStream)out, manifest);
        }
        finally {
            if (jarPlugin != null) {
                jarPlugin.close();
            }
        }
        jarFile.deleteOnExit();
        return jarFile;
    }
}

