/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;

public class ResolveAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.name.resolve.conflict", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return true;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (file.isDirectory()) {
            return true;
        }
        FileStatus fStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        return FileStatus.MERGED_WITH_CONFLICTS.equals(fStatus) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(fStatus);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.batchPerform(project, activeVcs, new VirtualFile[]{file}, context);
    }

    @Override
    protected void batchPerform(final Project project, final SvnVcs activeVcs, final VirtualFile[] files, DataContext context) throws VcsException {
        boolean hasDirs = false;
        for (VirtualFile file : files) {
            if (!file.isDirectory()) continue;
            hasDirs = true;
        }
        final ArrayList fileList = new ArrayList();
        if (!hasDirs) {
            Collections.addAll(fileList, files);
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : files) {
                        if (file.isDirectory()) {
                            ProjectLevelVcsManager.getInstance((Project)project).iterateVcsRoot(file, (Processor)new Processor<FilePath>(){

                                public boolean process(FilePath filePath) {
                                    ProgressManager.checkCanceled();
                                    VirtualFile fileOrDir = filePath.getVirtualFile();
                                    if (fileOrDir != null && !fileOrDir.isDirectory() && ResolveAction.this.isEnabled(project, activeVcs, fileOrDir) && !fileList.contains(fileOrDir)) {
                                        fileList.add(fileOrDir);
                                    }
                                    return true;
                                }
                            });
                            continue;
                        }
                        if (fileList.contains(file)) continue;
                        fileList.add(file);
                    }
                }
            }, SvnBundle.message("progress.searching.for.files.with.conflicts", new Object[0]), true, project);
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(fileList);
        fileList.removeAll(Arrays.asList(status.getReadonlyFiles()));
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog(fileList, (MergeProvider)new SvnMergeProvider(project));
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

