/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class BitShiftExpr
extends Expr {
    final String mOp;

    BitShiftExpr(Expr left, String op, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return BitShiftExpr.join(this.getLeft().getUniqueKey(), this.mOp, this.getRight().getUniqueKey());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return this.getLeft().getResolvedType();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public String getOp() {
        return this.mOp;
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode().app("", this.getLeft().toCode(expand)).app(this.getOp()).app("", this.getRight().toCode(expand));
    }

    @Override
    public String getInvertibleError() {
        return "Bit shift operators cannot be inverted in two-way binding";
    }
}

