/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.ArrayList;
import java.util.List;

public class IdentifierExpr
extends Expr {
    String mName;
    String mUserDefinedType;
    private boolean mIsDeclared;

    IdentifierExpr(String name) {
        super(new Expr[0]);
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setUserDefinedType(String userDefinedType) {
        this.mUserDefinedType = userDefinedType;
    }

    @Override
    protected String computeUniqueKey() {
        return IdentifierExpr.join(this.mName, super.computeUniqueKey());
    }

    public String getUserDefinedType() {
        return this.mUserDefinedType;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Preconditions.checkNotNull(this.mUserDefinedType, "Identifiers must have user defined types from the XML file. %s is missing it", this.mName);
        return modelAnalyzer.findClass(this.mUserDefinedType, this.getModel().getImports());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return new ArrayList<Dependency>();
    }

    @Override
    protected String asPackage() {
        return this.mUserDefinedType == null ? this.mName : null;
    }

    @Override
    protected KCode generateCode(boolean expand) {
        if (expand) {
            return new KCode(LayoutBinderWriterKt.getFieldName(this));
        }
        return new KCode(LayoutBinderWriterKt.scopedName(this));
    }

    public void setDeclared() {
        this.mIsDeclared = true;
    }

    public boolean isDeclared() {
        return this.mIsDeclared;
    }

    @Override
    public String getInvertibleError() {
        return null;
    }

    @Override
    public KCode toInverseCode(KCode value) {
        return new KCode().app(LayoutBinderWriterKt.getSetterName(this)).app("(", value).app(");");
    }
}

