/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class CompilerRunnerUtil {
    private static SoftReference<ClassLoader> ourClassLoaderRef = new SoftReference<Object>(null);

    @NotNull
    private static synchronized ClassLoader getOrCreateClassLoader(@NotNull CompilerEnvironment environment, @NotNull File libPath) throws IOException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "getOrCreateClassLoader"));
        }
        if (libPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libPath", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "getOrCreateClassLoader"));
        }
        ClassLoader classLoader = ourClassLoaderRef.get();
        if (classLoader == null) {
            classLoader = ClassPreloadingUtils.preloadClasses(Collections.singletonList(new File(libPath, "kotlin-compiler.jar")), 4096, CompilerRunnerUtil.class.getClassLoader(), environment.getClassesToLoadByParent());
            ourClassLoaderRef = new SoftReference<ClassLoader>(classLoader);
        }
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "getOrCreateClassLoader"));
        }
        return classLoader2;
    }

    @Nullable
    public static File getLibPath(@NotNull KotlinPaths paths, @NotNull MessageCollector messageCollector) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "getLibPath"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "getLibPath"));
        }
        File libs = paths.getLibPath();
        if (libs.exists() && !libs.isFile()) {
            return libs;
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Broken compiler at '" + libs.getAbsolutePath() + "'. Make sure plugin is properly installed", CompilerMessageLocation.NO_LOCATION);
        return null;
    }

    @Nullable
    public static Object invokeExecMethod(@NotNull String compilerClassName, @NotNull String[] arguments, @NotNull CompilerEnvironment environment, @NotNull MessageCollector messageCollector, @NotNull PrintStream out) throws Exception {
        if (compilerClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerClassName", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "invokeExecMethod"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "invokeExecMethod"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "invokeExecMethod"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "invokeExecMethod"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil", "invokeExecMethod"));
        }
        File libPath = CompilerRunnerUtil.getLibPath(environment.getKotlinPaths(), messageCollector);
        if (libPath == null) {
            return null;
        }
        ClassLoader classLoader = CompilerRunnerUtil.getOrCreateClassLoader(environment, libPath);
        Class<?> kompiler = Class.forName(compilerClassName, true, classLoader);
        Method exec = kompiler.getMethod("execAndOutputXml", PrintStream.class, Class.forName("org.jetbrains.kotlin.config.Services", true, classLoader), String[].class);
        return exec.invoke(kompiler.newInstance(), out, environment.getServices(), arguments);
    }
}

