/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.execution.RunManagerEx;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.impl.AntBeforeRunTask;
import com.intellij.lang.ant.config.impl.AntBeforeRunTaskProvider;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import icons.AntIcons;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

final class AntTargetNodeDescriptor
extends AntNodeDescriptor {
    private static final TextAttributes ourPostfixAttributes = new TextAttributes((Color)new JBColor(new Color(128, 0, 0), (Color)JBColor.RED), null, null, EffectType.BOXED, 0);
    private final AntBuildTargetBase myTarget;
    private CompositeAppearance myHighlightedText;

    public AntTargetNodeDescriptor(Project project, NodeDescriptor parentDescriptor, AntBuildTargetBase target) {
        super(project, parentDescriptor);
        this.myTarget = target;
        this.myHighlightedText = new CompositeAppearance();
    }

    public Object getElement() {
        return this.myTarget;
    }

    public AntBuildTargetBase getTarget() {
        return this.myTarget;
    }

    public boolean update() {
        CompositeAppearance oldText = this.myHighlightedText;
        boolean isMeta = this.myTarget instanceof MetaTarget;
        this.setIcon(isMeta ? AntIcons.MetaTarget : AntIcons.Target);
        this.myHighlightedText = new CompositeAppearance();
        AntBuildFile buildFile = isMeta ? ((MetaTarget)this.myTarget).getBuildFile() : this.myTarget.getModel().getBuildFile();
        Color color = buildFile.isTargetVisible(this.myTarget) ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        TextAttributes nameAttributes = new TextAttributes(color, null, null, EffectType.BOXED, this.myTarget.isDefault() ? 1 : 0);
        this.myHighlightedText.getEnding().addText(this.myTarget.getDisplayName(), nameAttributes);
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(this.myProject);
        ArrayList<Object> addedNames = new ArrayList<Object>(4);
        for (ExecutionEvent event : antConfiguration.getEventsForTarget(this.myTarget)) {
            Object presentableName;
            if (event instanceof ExecuteCompositeTargetEvent) {
                presentableName = ((ExecuteCompositeTargetEvent)event).getMetaTargetName();
                if (((String)presentableName).equals(this.myTarget.getName())) {
                    continue;
                }
            } else {
                presentableName = event.getPresentableName();
            }
            if (addedNames.contains(presentableName)) continue;
            addedNames.add(presentableName);
            this.myHighlightedText.getEnding().addText(" (" + (String)presentableName + ')', ourPostfixAttributes);
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        VirtualFile vFile = buildFile.getVirtualFile();
        if (vFile != null) {
            for (AntBeforeRunTask task : runManager.getBeforeRunTasks(AntBeforeRunTaskProvider.ID)) {
                if (!task.isRunningTarget(this.myTarget)) continue;
                this.myHighlightedText.getEnding().addText(" (Before Run/Debug)", ourPostfixAttributes);
                break;
            }
        }
        this.myName = this.myHighlightedText.getText();
        AntBuildTargetBase target = this.getTarget();
        if (!this.addShortcutText(target.getActionId()) && target.isDefault()) {
            this.addShortcutText(((AntBuildModelBase)target.getModel()).getDefaultTargetActionId());
        }
        return !Comparing.equal((Object)this.myHighlightedText, (Object)oldText);
    }

    private boolean addShortcutText(String actionId) {
        return AntTargetNodeDescriptor.addShortcutText(actionId, this.myHighlightedText);
    }

    public static boolean addShortcutText(String actionId, CompositeAppearance appearance) {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts(actionId);
        if (shortcuts != null && shortcuts.length > 0) {
            appearance.getEnding().addText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return true;
        }
        return false;
    }

    public CellAppearanceEx getHighlightedText() {
        return this.myHighlightedText;
    }

    @Override
    public boolean isAutoExpand() {
        return false;
    }

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/ant/config/explorer/AntTargetNodeDescriptor", "customize"));
        }
        this.getHighlightedText().customize(component);
        component.setIcon(this.getIcon());
        String toolTipText = this.getTarget().getNotEmptyDescription();
        component.setToolTipText(toolTipText);
    }

    @Override
    public void customize(@NotNull HtmlListCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/lang/ant/config/explorer/AntTargetNodeDescriptor", "customize"));
        }
        this.getHighlightedText().customize(renderer);
        renderer.setIcon(this.getIcon());
        String toolTipText = this.getTarget().getNotEmptyDescription();
        renderer.setToolTipText(toolTipText);
    }
}

