/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.PrintManager;
import com.intellij.codeEditor.printing.TextPainter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.List;

class MultiFilePainter
extends BasePainter {
    private final List<Pair<PsiFile, Editor>> myFilesList;
    private int myFileIndex = 0;
    private int myStartPageIndex = 0;
    private TextPainter myTextPainter = null;

    public MultiFilePainter(List<Pair<PsiFile, Editor>> filesList) {
        this.myFilesList = filesList;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.myProgress.isCanceled()) {
            return 1;
        }
        while (this.myFileIndex < this.myFilesList.size()) {
            if (this.myTextPainter == null) {
                Pair<PsiFile, Editor> pair = this.myFilesList.get(this.myFileIndex);
                this.myTextPainter = PrintManager.initTextPainter((PsiFile)pair.first, (Editor)pair.second);
            }
            if (this.myTextPainter != null) {
                this.myTextPainter.setProgress(this.myProgress);
                int ret = 0;
                try {
                    ret = this.myTextPainter.print(g, pageFormat, pageIndex - this.myStartPageIndex);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                if (this.myProgress.isCanceled()) {
                    return 1;
                }
                if (ret == 0) {
                    return 0;
                }
                this.myTextPainter.dispose();
                this.myTextPainter = null;
                this.myStartPageIndex = pageIndex;
            }
            ++this.myFileIndex;
        }
        return 1;
    }

    @Override
    void dispose() {
        if (this.myTextPainter != null) {
            this.myTextPainter.dispose();
            this.myTextPainter = null;
        }
    }
}

