/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CheckInitialized
implements ElementFilter {
    private final Set<PsiField> myNonInitializedFields;
    private final boolean myInsideConstructorCall;

    CheckInitialized(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/CheckInitialized", "<init>"));
        }
        this.myNonInitializedFields = CheckInitialized.getNonInitializedFields(position);
        this.myInsideConstructorCall = CheckInitialized.isInsideConstructorCall(position);
    }

    static boolean isInsideConstructorCall(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/CheckInitialized", "isInsideConstructorCall"));
        }
        return ExpressionUtils.isConstructorInvocation(PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class)) && !JavaKeywordCompletion.AFTER_DOT.accepts((Object)position);
    }

    private static boolean isInitializedImplicitly(PsiField field) {
        field = CompletionUtil.getOriginalOrSelf(field);
        for (ImplicitUsageProvider provider : (ImplicitUsageProvider[])ImplicitUsageProvider.EP_NAME.getExtensions()) {
            if (!provider.isImplicitWrite((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    static Set<PsiField> getNonInitializedFields(PsiElement element) {
        final PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (statement2 == null || method == null || !method.isConstructor()) {
            return Collections.emptySet();
        }
        PsiElement parent = element.getParent();
        while (parent != statement2) {
            PsiStatement psiStatement;
            PsiElement next = parent.getParent();
            if (next instanceof PsiAssignmentExpression && parent == ((PsiAssignmentExpression)next).getLExpression()) {
                return Collections.emptySet();
            }
            if (parent instanceof PsiJavaCodeReferenceElement && (psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class)) != null && psiStatement.getTextRange().getStartOffset() == parent.getTextRange().getStartOffset()) {
                return Collections.emptySet();
            }
            parent = next;
        }
        final HashSet<PsiField> fields = new HashSet<PsiField>();
        PsiClass containingClass = method.getContainingClass();
        assert (containingClass != null);
        for (PsiField field : containingClass.getFields()) {
            if (field.hasModifierProperty("static") || field.getInitializer() != null || CheckInitialized.isInitializedImplicitly(field)) continue;
            fields.add(field);
        }
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression lExpression;
                if (expression.getTextRange().getStartOffset() < statement2.getTextRange().getStartOffset() && (lExpression = expression.getLExpression()) instanceof PsiReferenceExpression) {
                    fields.remove(((PsiReferenceExpression)lExpression).resolve());
                }
                super.visitAssignmentExpression(expression);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiReferenceExpression methodExpression;
                if (expression.getTextRange().getStartOffset() < statement2.getTextRange().getStartOffset() && (methodExpression = expression.getMethodExpression()).textMatches((CharSequence)"this")) {
                    fields.clear();
                }
                super.visitMethodCallExpression(expression);
            }
        });
        return fields;
    }

    public boolean isAcceptable(Object element, @Nullable PsiElement context) {
        if (element instanceof CandidateInfo) {
            element = ((CandidateInfo)element).getElement();
        }
        if (element instanceof PsiField) {
            return !this.myNonInitializedFields.contains(element);
        }
        if (element instanceof PsiMethod && this.myInsideConstructorCall) {
            return ((PsiMethod)element).hasModifierProperty("static");
        }
        return true;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

