/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionServiceImpl
extends CompletionService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.impl.CompletionServiceImpl");
    private static volatile CompletionPhase ourPhase = CompletionPhase.NoCompletion;
    private static String ourPhaseTrace;

    public CompletionServiceImpl() {
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectClosing(Project project2) {
                CompletionProgressIndicator indicator = CompletionServiceImpl.this.getCurrentCompletion();
                if (indicator != null && indicator.getProject() == project2) {
                    indicator.closeAndFinish(true);
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                } else if (indicator == null) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        });
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    public String getAdvertisementText() {
        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        return completion == null ? null : (String)ContainerUtil.getFirstItem(completion.getLookup().getAdvertisements());
    }

    public void setAdvertisementText(@Nullable String text) {
        if (text == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (completion != null) {
            completion.addAdvertisement(text, null);
        }
    }

    public CompletionResultSet createResultSet(CompletionParameters parameters, Consumer<CompletionResult> consumer, @NotNull CompletionContributor contributor) {
        if (contributor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl", "createResultSet"));
        }
        PsiElement position = parameters.getPosition();
        int offset = parameters.getOffset();
        assert (position.getTextRange().containsOffset(offset)) : position;
        String prefix = CompletionData.findPrefixStatic(position, offset);
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
        CompletionSorterImpl sorter = this.defaultSorter(parameters, matcher);
        return new CompletionResultSetImpl(consumer, offset, matcher, contributor, parameters, sorter, null);
    }

    public CompletionProgressIndicator getCurrentCompletion() {
        if (CompletionServiceImpl.isPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
            return CompletionServiceImpl.ourPhase.indicator;
        }
        return null;
    }

    public static boolean assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (!CompletionServiceImpl.isPhase(possibilities)) {
            LOG.error(ourPhase + "; set at " + ourPhaseTrace);
            return false;
        }
        return true;
    }

    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl", "setCompletionPhase"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        CompletionProgressIndicator oldIndicator = oldPhase.indicator;
        if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation)) {
            LOG.assertTrue(!oldIndicator.isRunning() || oldIndicator.isCanceled(), (Object)("don't change phase during running completion: oldPhase=" + oldPhase));
        }
        Disposer.dispose((Disposable)oldPhase);
        ourPhase = phase;
        ourPhaseTrace = DebugUtil.currentStackTrace();
    }

    public static CompletionPhase getCompletionPhase() {
        CompletionPhase phase = CompletionServiceImpl.getPhaseRaw();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
        }
        return phase;
    }

    public static CompletionPhase getPhaseRaw() {
        return ourPhase;
    }

    public CompletionSorterImpl defaultSorter(CompletionParameters parameters, PrefixMatcher matcher) {
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new DispreferLiveTemplates()));
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher : WeighingService.getWeighers((Key)CompletionService.RELEVANCE_KEY)) {
            String id = weigher.toString();
            if ("prefix".equals(id)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id)) {
                sorter = sorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

                    @Override
                    public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                        return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
                    }
                });
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(id, true, false){

                public Comparable weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$3", "weigh"));
                    }
                    return weigher.weigh((Object)element, (Object)location);
                }
            });
        }
        return sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>("liftShorter"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
    }

    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList<ClassifierFactory<LookupElement>>());
    }

    public static boolean isStartMatch(LookupElement element, WeighingContext context) {
        return CompletionServiceImpl.getItemMatcher(element, context).isStartMatch(element);
    }

    static PrefixMatcher getItemMatcher(LookupElement element, WeighingContext context) {
        PrefixMatcher itemMatcher = context.itemMatcher(element);
        String pattern = context.itemPattern(element);
        if (!pattern.equals(itemMatcher.getPrefix())) {
            return itemMatcher.cloneWithPrefix(pattern);
        }
        return itemMatcher;
    }

    private static class CompletionResultSetImpl
    extends CompletionResultSet {
        private final int myLengthOfTextBeforePosition;
        private final CompletionParameters myParameters;
        private final CompletionSorterImpl mySorter;
        @Nullable
        private final CompletionResultSetImpl myOriginal;

        public CompletionResultSetImpl(Consumer<CompletionResult> consumer, int lengthOfTextBeforePosition, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters, @NotNull CompletionSorterImpl sorter, @Nullable CompletionResultSetImpl original) {
            if (sorter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorter", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "<init>"));
            }
            super(prefixMatcher, consumer, contributor);
            this.myLengthOfTextBeforePosition = lengthOfTextBeforePosition;
            this.myParameters = parameters;
            this.mySorter = sorter;
            this.myOriginal = original;
        }

        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "addElement"));
            }
            if (!element.isValid()) {
                LOG.error("Invalid lookup element: " + element + " of " + element.getClass() + " in " + this.myParameters.getOriginalFile() + " of " + this.myParameters.getOriginalFile().getClass());
                return;
            }
            CompletionResult matched = CompletionResult.wrap((LookupElement)element, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.mySorter);
            if (matched != null) {
                this.passResult(matched);
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "withPrefixMatcher"));
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl((Consumer<CompletionResult>)this.getConsumer(), this.myLengthOfTextBeforePosition, matcher, this.myContributor, this.myParameters, this.mySorter, this);
            if (completionResultSetImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "withPrefixMatcher"));
            }
            return completionResultSetImpl;
        }

        public void stopHere() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "withPrefixMatcher"));
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(new CamelHumpMatcher(prefix));
            if (completionResultSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "withPrefixMatcher"));
            }
            return completionResultSet;
        }

        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorter", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "withRelevanceSorter"));
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl((Consumer<CompletionResult>)this.getConsumer(), this.myLengthOfTextBeforePosition, this.getPrefixMatcher(), this.myContributor, this.myParameters, (CompletionSorterImpl)sorter, this);
            if (completionResultSetImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "withRelevanceSorter"));
            }
            return completionResultSetImpl;
        }

        public void addLookupAdvertisement(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "addLookupAdvertisement"));
            }
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text);
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            CompletionResultSet completionResultSet = this.withPrefixMatcher(new CamelHumpMatcher(this.getPrefixMatcher().getPrefix(), false));
            if (completionResultSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl", "caseInsensitive"));
            }
            return completionResultSet;
        }

        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProgressIndicator indicator = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (indicator != null) {
                indicator.addWatchedPrefix(this.myLengthOfTextBeforePosition - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        public void restartCompletionWhenNothingMatches() {
            CompletionProgressIndicator indicator = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (indicator != null) {
                indicator.getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }
    }
}

