/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.RainbowIdentifierHighlighterPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RainbowIdentifierHighlighterPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public RainbowIdentifierHighlighterPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, false, -1);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("RainbowIdentifierPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "getComponentName"));
        }
        return "RainbowIdentifierPassFactory";
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "createHighlightingPass"));
        }
        if (RainbowHighlighter.isRainbowEnabled() && this.isValidContext(file2, editor)) {
            return this.getRainbowPass(file2, editor);
        }
        return null;
    }

    @NotNull
    protected RainbowIdentifierHighlighterPass getRainbowPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "getRainbowPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "getRainbowPass"));
        }
        RainbowIdentifierHighlighterPass rainbowIdentifierHighlighterPass = new RainbowIdentifierHighlighterPass(file2, editor);
        if (rainbowIdentifierHighlighterPass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "getRainbowPass"));
        }
        return rainbowIdentifierHighlighterPass;
    }

    protected boolean isValidContext(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "isValidContext"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPassFactory", "isValidContext"));
        }
        return true;
    }
}

