/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeFileLocalInspectionsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final Map<PsiFile, Boolean> myFileToolsCache = ContainerUtil.createConcurrentWeakMap();
    private final InspectionProjectProfileManager myProfileManager;
    private volatile long myPsiModificationCount;

    public WholeFileLocalInspectionsPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar, InspectionProjectProfileManager profileManager) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
        this.myProfileManager = profileManager;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WholeFileLocalInspectionsPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "getComponentName"));
        }
        return "WholeFileLocalInspectionsPassFactory";
    }

    public void projectOpened() {
        ProfileChangeAdapter myProfilesListener = new ProfileChangeAdapter(){

            public void profileChanged(Profile profile) {
                WholeFileLocalInspectionsPassFactory.this.myFileToolsCache.clear();
            }

            public void profileActivated(Profile oldProfile, Profile profile) {
                WholeFileLocalInspectionsPassFactory.this.myFileToolsCache.clear();
            }
        };
        this.myProfileManager.addProfilesListener(myProfilesListener, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, this.myFileToolsCache::clear);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "createHighlightingPass"));
        }
        long psiModificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (psiModificationCount == this.myPsiModificationCount) {
            return null;
        }
        if (!InspectionProjectProfileManager.getInstance(file2.getProject()).isProfileLoaded() || this.myFileToolsCache.containsKey(file2) && !this.myFileToolsCache.get(file2).booleanValue()) {
            return null;
        }
        return new LocalInspectionsPass(file2, editor.getDocument(), 0, file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, new DefaultHighlightInfoProcessor()){

            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
                if (profile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "getInspectionTools"));
                }
                List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile);
                List<LocalInspectionToolWrapper> result2 = tools.stream().filter(LocalInspectionToolWrapper::runForWholeFile).collect(Collectors.toList());
                WholeFileLocalInspectionsPassFactory.this.myFileToolsCache.put(file2, !result2.isEmpty());
                List<LocalInspectionToolWrapper> list = result2;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "getInspectionTools"));
                }
                return list;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            @Override
            void inspectInjectedPsi(@NotNull List<PsiElement> elements, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
                if (iManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
                if (wrappers == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
            }

            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
            }
        };
    }
}

