/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HtmlFileReferenceHelper
extends FileReferenceHelper {
    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project2, @NotNull VirtualFile vFile) {
        Module module2;
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
        }
        PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(vFile);
        Module module3 = module2 = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        if (module2 == null || !(file2 instanceof XmlFile)) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
            }
            return list;
        }
        String basePath = HtmlUtil.getHrefBase((XmlFile)file2);
        if (basePath != null && !HtmlUtil.hasHtmlPrefix(basePath)) {
            for (VirtualFile virtualFile : this.getBaseRoots(module2)) {
                VirtualFile base = virtualFile.findFileByRelativePath(basePath);
                PsiDirectory result2 = base != null ? PsiManager.getInstance((Project)project2).findDirectory(base) : null;
                if (result2 == null) continue;
                List<PsiDirectory> list = Collections.singletonList(result2);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
                }
                return list;
            }
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    protected Collection<VirtualFile> getBaseRoots(Module module2) {
        return Arrays.asList(ModuleRootManager.getInstance((Module)module2).getContentRoots());
    }

    @Override
    public boolean isMine(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "isMine"));
        }
        FileType fileType = file2.getFileType();
        return ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2) && fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }
}

