/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.BundleBase;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.IdeValidationHost;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.RequiredAttributesInspectionBase;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.lang.ASTNode;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitor
extends XmlElementVisitor
implements HighlightVisitor,
IdeValidationHost {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor");
    private static final UserDataCache<Boolean, PsiElement, Object> DO_NOT_VALIDATE = new UserDataCache<Boolean, PsiElement, Object>("do not validate"){

        protected Boolean compute(PsiElement parent, Object p) {
            OuterLanguageElement element = (OuterLanguageElement)PsiTreeUtil.getChildOfType((PsiElement)parent, OuterLanguageElement.class);
            if (element == null) {
                for (PsiElement child = parent.getFirstChild(); !(child == null || child instanceof XmlText && (element = (OuterLanguageElement)PsiTreeUtil.getChildOfType((PsiElement)child, OuterLanguageElement.class)) != null); child = child.getNextSibling()) {
                }
            }
            if (element == null) {
                return false;
            }
            PsiFile containingFile = parent.getContainingFile();
            return containingFile.getViewProvider().getBaseLanguage() != containingFile.getLanguage();
        }
    };
    private static boolean ourDoJaxpTesting;
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES;
    private HighlightInfoHolder myHolder;

    private void addElementsForTag(XmlTag tag, @NotNull String localizedMessage, HighlightInfoType type, IntentionAction quickFixAction) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "addElementsForTag"));
        }
        this.addElementsForTagWithManyQuickFixes(tag, localizedMessage, type, quickFixAction);
    }

    private void addElementsForTagWithManyQuickFixes(XmlTag tag, @NotNull String localizedMessage, HighlightInfoType type, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "addElementsForTagWithManyQuickFixes"));
        }
        this.bindMessageToTag(tag, type, -1, localizedMessage, quickFixActions);
    }

    public void visitXmlToken(XmlToken token) {
        XmlTag tag;
        String marker;
        String s;
        int i;
        IElementType tokenType = token.getTokenType();
        if (tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) {
            PsiElement element = token.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            if (element instanceof XmlToken) {
                PsiElement parent;
                if (((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkTag((XmlTag)parent);
                }
            } else {
                PsiElement parent = token.getParent();
                if (parent instanceof XmlAttribute && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkAttribute((XmlAttribute)parent);
                }
            }
        } else if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && token.getParent() instanceof XmlText && token.textContains(']') && token.textContains('>') && (i = (s = token.getText()).indexOf(marker = "]]>")) != -1 && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)token, XmlTag.class)) != null && XmlExtension.getExtensionByElement((PsiElement)tag).shouldBeHighlightedAsTag(tag) && !XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            TextRange textRange = token.getTextRange();
            int start = textRange.getStartOffset() + i;
            HighlightInfoType type = tag instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description = XmlErrorMessages.message("cdata.end.should.not.appear.in.content.unless.to.mark.end.of.cdata.section", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(type).range(start, start + marker.length()).descriptionAndTooltip(description).create();
            this.addToResults(info);
        }
    }

    private void checkTag(XmlTag tag) {
        if (ourDoJaxpTesting) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.checkTagByDescriptor(tag);
        }
        if (!this.myHolder.hasErrorResults() && !XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (tag instanceof HtmlTag && (descriptor instanceof AnyXmlElementDescriptor || descriptor == null)) {
                return;
            }
            this.checkReferences((PsiElement)tag);
        }
    }

    private void bindMessageToTag(XmlTag tag, HighlightInfoType warning, int messageLength, @NotNull String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "bindMessageToTag"));
        }
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, 0, messageLength, localizedMessage, quickFixActions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, 0, messageLength, localizedMessage, quickFixActions);
    }

    public void visitXmlProcessingInstruction(XmlProcessingInstruction processingInstruction) {
        super.visitXmlProcessingInstruction(processingInstruction);
        PsiElement parent = processingInstruction.getParent();
        if (parent instanceof XmlProlog && processingInstruction.getText().startsWith("<?xml")) {
            PsiElement e = PsiTreeUtil.prevLeaf((PsiElement)processingInstruction);
            while (e != null) {
                if (!(e instanceof PsiWhiteSpace && PsiTreeUtil.prevLeaf((PsiElement)e) != null || e instanceof OuterLanguageElement)) {
                    PsiElement eParent = e.getParent();
                    if (eParent instanceof PsiComment) {
                        e = eParent;
                    }
                    if (eParent instanceof XmlProcessingInstruction) break;
                    String description = XmlErrorMessages.message("xml.declaration.should.precede.all.document.content", new Object[0]);
                    this.addToResults(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(e).descriptionAndTooltip(description).create());
                }
                e = PsiTreeUtil.prevLeaf((PsiElement)e);
            }
        }
        this.checkReferences((PsiElement)processingInstruction);
    }

    private void bindMessageToAstNode(PsiElement childByRole, HighlightInfoType warning, int offset, int length, @NotNull String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "bindMessageToAstNode"));
        }
        if (childByRole != null) {
            TextRange textRange = childByRole.getTextRange();
            if (length == -1) {
                length = textRange.getLength();
            }
            int startOffset = textRange.getStartOffset() + offset;
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(warning).range(childByRole, startOffset, startOffset + length).descriptionAndTooltip(localizedMessage).create();
            if (highlightInfo == null) {
                highlightInfo = HighlightInfo.newHighlightInfo(warning).range(new TextRange(startOffset, startOffset + length)).textAttributes(NONEMPTY_TEXT_ATTRIBUTES).descriptionAndTooltip(localizedMessage).create();
            }
            for (IntentionAction quickFixAction : quickFixActions) {
                if (quickFixAction == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, textRange, quickFixAction);
            }
            this.addToResults(highlightInfo);
        }
    }

    private void checkTagByDescriptor(XmlTag tag) {
        XmlElementDescriptor elementDescriptor;
        String name = tag.getName();
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null && elementDescriptor == null && XmlHighlightVisitor.shouldBeValidated(tag)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                this.addElementsForTag(tag, XmlErrorMessages.message("element.is.not.allowed.here", name), XmlHighlightVisitor.getTagProblemInfoType(tag), null);
                return;
            }
            if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
                elementDescriptor = tag.getDescriptor();
            }
            if (elementDescriptor == null) {
                return;
            }
        } else {
            elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null) {
                this.addElementsForTag(tag, XmlErrorMessages.message("element.must.be.declared", name), HighlightInfoType.WRONG_REF, null);
                return;
            }
        }
        if (!(elementDescriptor instanceof XmlHighlightingAwareElementDescriptor) || ((XmlHighlightingAwareElementDescriptor)elementDescriptor).shouldCheckRequiredAttributes()) {
            this.checkRequiredAttributes(tag, name, elementDescriptor);
        }
        if (elementDescriptor instanceof Validator) {
            ((Validator)elementDescriptor).validate(tag, this);
        }
    }

    private void checkRequiredAttributes(XmlTag tag, String name, XmlElementDescriptor elementDescriptor) {
        XmlAttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashSet<String> requiredAttributes = null;
        for (XmlAttributeDescriptor attribute : attributeDescriptors) {
            if (attribute == null || !attribute.isRequired()) continue;
            if (requiredAttributes == null) {
                requiredAttributes = new HashSet<String>();
            }
            requiredAttributes.add(attribute.getName((PsiElement)tag));
        }
        if (requiredAttributes != null) {
            for (String attrName : requiredAttributes) {
                if (XmlHighlightVisitor.hasAttribute(tag, attrName) || XmlExtension.getExtension(tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, attrName)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement insertRequiredAttributeIntention = XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, attrName, new String[0]);
                String localizedMessage = XmlErrorMessages.message("element.doesnt.have.required.attribute", name, attrName);
                InspectionProfile profile = InspectionProjectProfileManager.getInstance(tag.getProject()).getInspectionProfile();
                RequiredAttributesInspectionBase inspection = (RequiredAttributesInspectionBase)profile.getUnwrappedTool("RequiredAttributes", (PsiElement)tag);
                if (inspection == null) continue;
                this.reportOneTagProblem(tag, attrName, localizedMessage, (IntentionAction)insertRequiredAttributeIntention, HighlightDisplayKey.find((String)"RequiredAttributes"), inspection, RequiredAttributesInspectionBase.getIntentionAction(attrName));
            }
        }
    }

    private static boolean hasAttribute(XmlTag tag, String attrName) {
        XmlAttribute attribute = tag.getAttribute(attrName);
        if (attribute == null) {
            return false;
        }
        if (attribute.getValueElement() != null) {
            return true;
        }
        if (!(tag instanceof HtmlTag)) {
            return false;
        }
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, (PsiElement)tag);
    }

    private void reportOneTagProblem(XmlTag tag, String name, @NotNull String localizedMessage, IntentionAction basicIntention, HighlightDisplayKey key2, XmlEntitiesInspection inspection, IntentionAction addAttributeFix) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "reportOneTagProblem"));
        }
        boolean htmlTag = false;
        if (tag instanceof HtmlTag) {
            htmlTag = true;
            if (XmlHighlightVisitor.isAdditionallyDeclared(inspection.getAdditionalEntries(), name)) {
                return;
            }
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(tag.getProject()).getInspectionProfile();
        if (htmlTag && profile.isToolEnabled(key2, (PsiElement)tag)) {
            this.addElementsForTagWithManyQuickFixes(tag, localizedMessage, XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag) ? HighlightInfoType.INFORMATION : SeverityRegistrar.getSeverityRegistrar(tag.getProject()).getHighlightInfoTypeBySeverity(profile.getErrorLevel(key2, (PsiElement)tag).getSeverity()), addAttributeFix, basicIntention);
        } else if (!htmlTag) {
            this.addElementsForTag(tag, localizedMessage, HighlightInfoType.ERROR, basicIntention);
        }
    }

    private static boolean isAdditionallyDeclared(String additional, String name) {
        if (!additional.contains(name = name.toLowerCase())) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(additional, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    private static HighlightInfoType getTagProblemInfoType(XmlTag tag) {
        if (tag instanceof HtmlTag && "http://www.w3.org/1999/html".equals(tag.getNamespace())) {
            if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag)) {
                return HighlightInfoType.INFORMATION;
            }
            return HighlightInfoType.WARNING;
        }
        return HighlightInfoType.WRONG_REF;
    }

    public static boolean isInjectedWithoutValidation(PsiElement element) {
        PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost((PsiElement)element.getContainingFile());
        return context != null && XmlHighlightVisitor.skipValidation((PsiElement)context);
    }

    public static boolean skipValidation(PsiElement context) {
        return (Boolean)DO_NOT_VALIDATE.get((UserDataHolder)context, null);
    }

    public static void setSkipValidation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "setSkipValidation"));
        }
        DO_NOT_VALIDATE.put((UserDataHolder)element, (Object)Boolean.TRUE);
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
    }

    private void checkAttribute(XmlAttribute attribute) {
        PsiElement prevLeaf;
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return;
        }
        String name = attribute.getName();
        if (XmlExtension.getExtension(attribute.getContainingFile()).needWhitespaceBeforeAttribute() && !((prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)attribute)) instanceof PsiWhiteSpace)) {
            TextRange textRange = attribute.getTextRange();
            HighlightInfoType type = tag instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description = XmlErrorMessages.message("attribute.should.be.preceded.with.space", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(type).range(textRange.getStartOffset(), textRange.getStartOffset()).descriptionAndTooltip(description).create();
            this.addToResults(info);
        }
        if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            return;
        }
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor || ourDoJaxpTesting) {
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
        if (attributeDescriptor == null) {
            PsiFile file2;
            String localizedMessage;
            HighlightInfo highlightInfo;
            if (!XmlUtil.attributeFromTemplateFramework(name, tag) && (highlightInfo = this.reportAttributeProblem(tag, name, attribute, localizedMessage = XmlErrorMessages.message("attribute.is.not.allowed.here", name))) != null && (file2 = tag.getContainingFile()) != null) {
                for (XmlUndefinedElementFixProvider fixProvider : (XmlUndefinedElementFixProvider[])Extensions.getExtensions(XmlUndefinedElementFixProvider.EP_NAME)) {
                    IntentionAction[] fixes = fixProvider.createFixes(attribute);
                    if (fixes == null) continue;
                    for (IntentionAction action : fixes) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, action);
                    }
                    break;
                }
            }
        } else {
            this.checkDuplicateAttribute(tag, attribute);
            PsiReference[] attrRefs = attribute.getReferences();
            this.doCheckRefs((PsiElement)attribute, attrRefs, !attribute.getNamespacePrefix().isEmpty() ? 2 : 1);
        }
    }

    @Nullable
    private HighlightInfo reportAttributeProblem(XmlTag tag, String localName, XmlAttribute attribute, @NotNull String localizedMessage) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "reportAttributeProblem"));
        }
        RemoveAttributeIntentionFix removeAttributeIntention = new RemoveAttributeIntentionFix(localName, attribute);
        if (!(tag instanceof HtmlTag)) {
            HighlightInfoType tagProblemInfoType = HighlightInfoType.WRONG_REF;
            ASTNode node = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (node != null);
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
            assert (child != null);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(tagProblemInfoType).range(child).descriptionAndTooltip(localizedMessage).create();
            this.addToResults(highlightInfo);
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)removeAttributeIntention);
            return highlightInfo;
        }
        return null;
    }

    private void checkDuplicateAttribute(XmlTag tag, XmlAttribute attribute) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            return;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        PsiFile containingFile = tag.getContainingFile();
        XmlExtension extension = containingFile instanceof XmlFile ? XmlExtension.getExtension(containingFile) : DefaultXmlExtension.DEFAULT_EXTENSION;
        for (XmlAttribute tagAttribute : attributes) {
            ProgressManager.checkCanceled();
            if (attribute == tagAttribute || !Comparing.strEqual((String)attribute.getName(), (String)tagAttribute.getName())) continue;
            String localName = attribute.getLocalName();
            if (extension.canBeDuplicated(tagAttribute)) continue;
            ASTNode attributeNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (attributeNode != null);
            ASTNode attributeNameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attributeNode);
            assert (attributeNameNode != null);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(XmlHighlightVisitor.getTagProblemInfoType(tag)).range(attributeNameNode).descriptionAndTooltip(XmlErrorMessages.message("duplicate.attribute", localName)).create();
            this.addToResults(highlightInfo);
            RemoveAttributeIntentionFix intentionAction = new RemoveAttributeIntentionFix(localName, attribute);
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)intentionAction);
        }
    }

    public void visitXmlDocument(XmlDocument document2) {
        PsiMetaData psiMetaData;
        if (document2.getLanguage() == DTDLanguage.INSTANCE && (psiMetaData = document2.getMetaData()) instanceof Validator) {
            ((Validator)psiMetaData).validate(document2, this);
        }
    }

    public void visitXmlTag(XmlTag tag) {
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        String error;
        XmlAttributeDescriptor attributeDescriptor;
        this.checkReferences((PsiElement)value);
        PsiElement parent = value.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        XmlTag tag = attribute.getParent();
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        XmlAttributeDescriptor xmlAttributeDescriptor = attributeDescriptor = elementDescriptor != null ? elementDescriptor.getAttributeDescriptor(attribute) : null;
        if (attributeDescriptor != null && !XmlHighlightVisitor.skipValidation((PsiElement)value) && (error = attributeDescriptor.validateValue((XmlElement)value, attribute.getValue())) != null) {
            HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType(tag);
            this.addToResults(HighlightInfo.newHighlightInfo(type).range((PsiElement)value).descriptionAndTooltip(error).create());
        }
    }

    private void checkReferences(PsiElement value) {
        if (value == null) {
            return;
        }
        this.doCheckRefs(value, value.getReferences(), 0);
    }

    private void doCheckRefs(PsiElement value, PsiReference[] references, int start) {
        for (int i = start; i < references.length; ++i) {
            LocalQuickFix[] fixes;
            PsiElement parent;
            PsiReference reference = references[i];
            ProgressManager.checkCanceled();
            if (XmlHighlightVisitor.isUrlReference(reference) || !XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
            String description = XmlHighlightVisitor.getErrorDescription(reference);
            int startOffset = reference.getElement().getTextRange().getStartOffset();
            TextRange referenceRange = reference.getRangeInElement();
            if (referenceRange.getStartOffset() > referenceRange.getEndOffset()) {
                LOG.error("Reference range start offset > end offset:  " + reference + ", start offset: " + referenceRange.getStartOffset() + ", end offset: " + referenceRange.getEndOffset());
            }
            HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class));
            if (value instanceof XmlAttributeValue && (parent = value.getParent()) instanceof XmlAttribute) {
                String name = ((XmlAttribute)parent).getName().toLowerCase();
                if (type.getSeverity(null).compareTo(HighlightInfoType.WARNING.getSeverity(null)) > 0 && name.endsWith("stylename")) {
                    type = HighlightInfoType.WARNING;
                }
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(type).range(startOffset + referenceRange.getStartOffset(), startOffset + referenceRange.getEndOffset()).descriptionAndTooltip(description).create();
            this.addToResults(info);
            if (reference instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
                InspectionManager manager = InspectionManager.getInstance((Project)reference.getElement().getProject());
                for (LocalQuickFix fix : fixes) {
                    ProblemDescriptor descriptor = manager.createProblemDescriptor(value, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true);
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)new LocalQuickFixAsIntentionAdapter(fix, descriptor));
                }
            }
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(reference, new QuickFixActionRegistrarImpl(info));
        }
    }

    public static boolean isUrlReference(PsiReference reference) {
        return reference instanceof FileReferenceOwner || reference instanceof AnchorReference;
    }

    @NotNull
    public static String getErrorDescription(@NotNull PsiReference reference) {
        String description;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "getErrorDescription"));
        }
        String message = reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : PsiBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description = BundleBase.format((String)message, (Object[])new Object[]{reference.getCanonicalText()});
        }
        catch (IllegalArgumentException ex) {
            description = message;
        }
        String string = description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "getErrorDescription"));
        }
        return string;
    }

    public static boolean hasBadResolve(PsiReference reference, boolean checkSoft) {
        if (!checkSoft && reference.isSoft()) {
            return false;
        }
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length == 0;
        }
        return reference.resolve() == null;
    }

    public void visitXmlDoctype(XmlDoctype xmlDoctype) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)xmlDoctype)) {
            return;
        }
        this.checkReferences((PsiElement)xmlDoctype);
    }

    private void addToResults(HighlightInfo info) {
        this.myHolder.add(info);
    }

    public static void setDoJaxpTesting(boolean doJaxpTesting) {
        ourDoJaxpTesting = doJaxpTesting;
    }

    @Override
    public void addMessage(PsiElement context, String message, int type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMessage(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "addMessage"));
        }
        this.addMessageWithFixes(context, message, type, new IntentionAction[0]);
    }

    @Override
    public void addMessageWithFixes(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type, IntentionAction ... fixes) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "addMessageWithFixes"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "addMessageWithFixes"));
        }
        if (message != null && !message.isEmpty()) {
            HighlightInfoType defaultInfoType;
            PsiFile containingFile = context.getContainingFile();
            HighlightInfoType highlightInfoType = type == Validator.ValidationHost.ErrorType.ERROR ? HighlightInfoType.ERROR : (defaultInfoType = type == Validator.ValidationHost.ErrorType.WARNING ? HighlightInfoType.WARNING : HighlightInfoType.WEAK_WARNING);
            if (context instanceof XmlTag && XmlExtension.getExtension(containingFile).shouldBeHighlightedAsTag((XmlTag)context)) {
                this.addElementsForTagWithManyQuickFixes((XmlTag)context, message, defaultInfoType, fixes);
            } else {
                HighlightInfo highlightInfo;
                PsiLanguageInjectionHost contextOfFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
                if (contextOfFile != null) {
                    TextRange range = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(context, context.getTextRange());
                    highlightInfo = HighlightInfo.newHighlightInfo(defaultInfoType).range(range).descriptionAndTooltip(message).create();
                } else {
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(context).descriptionAndTooltip(message).create();
                }
                for (IntentionAction quickFixAction : fixes) {
                    if (quickFixAction == null) continue;
                    QuickFixAction.registerQuickFixAction(highlightInfo, quickFixAction);
                }
                this.addToResults(highlightInfo);
            }
        }
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "suitableForFile"));
        }
        if (file2 instanceof XmlFile) {
            return true;
        }
        for (PsiFile psiFile : file2.getViewProvider().getAllFiles()) {
            if (!(psiFile instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "visit"));
        }
        element.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "analyze"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "analyze"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "analyze"));
        }
        this.myHolder = holder;
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
        }
        return true;
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        XmlHighlightVisitor xmlHighlightVisitor = new XmlHighlightVisitor();
        if (xmlHighlightVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "clone"));
        }
        return xmlHighlightVisitor;
    }

    @Override
    public int order() {
        return 1;
    }

    public static String getUnquotedValue(XmlAttributeValue value, XmlTag tag) {
        String unquotedValue = value.getValue();
        if (tag instanceof HtmlTag) {
            unquotedValue = unquotedValue.toLowerCase();
        }
        return unquotedValue;
    }

    public static boolean shouldBeValidated(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor", "shouldBeValidated"));
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            return !XmlHighlightVisitor.skipValidation(parent) && !XmlUtil.tagFromTemplateFramework(tag);
        }
        return true;
    }

    static {
        NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

            public boolean isEmpty() {
                return false;
            }
        };
    }
}

