/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final boolean myIsDirectory;
    private final String myNewFileName;
    private final String myText;
    @NotNull
    private final String myKey;
    private boolean myIsAvailable;
    private long myIsAvailableTimeStamp;
    private static final int REFRESH_INTERVAL = 1000;

    public CreateFileFix(boolean isDirectory, @NotNull String newFileName, @NotNull PsiDirectory directory, @Nullable String text, @NotNull String key2) {
        if (newFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileName", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        super((PsiElement)directory);
        this.myIsDirectory = isDirectory;
        this.myNewFileName = newFileName;
        this.myText = text;
        this.myKey = key2;
        this.myIsAvailable = isDirectory || !FileTypeManager.getInstance().getFileTypeByFileName(newFileName).isBinary();
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateFileFix(@NotNull String newFileName, @NotNull PsiDirectory directory, String text) {
        if (newFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileName", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        this(false, newFileName, directory, text, "create.file.text");
    }

    public CreateFileFix(boolean isDirectory, @NotNull String newFileName, @NotNull PsiDirectory directory) {
        if (newFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileName", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "<init>"));
        }
        this(isDirectory, newFileName, directory, null, isDirectory ? "create.directory.text" : "create.file.text");
    }

    @Nullable
    protected String getFileText() {
        return this.myText;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{this.myNewFileName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(final @NotNull Project project2, @NotNull PsiFile file2, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "invoke"));
        }
        final PsiDirectory myDirectory = (PsiDirectory)startElement;
        if (this.isAvailable(project2, null, file2)) {
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix$1", "run"));
                    }
                    CreateFileFix.this.invoke(project2, myDirectory);
                }
            }.execute();
        }
    }

    public void applyFix() {
        this.invoke(this.myStartElement.getProject(), (PsiDirectory)this.myStartElement.getElement());
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "isAvailable"));
        }
        PsiDirectory myDirectory = (PsiDirectory)startElement;
        long current = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode() || current - this.myIsAvailableTimeStamp > 1000L) {
            this.myIsAvailable &= myDirectory.getVirtualFile().findChild(this.myNewFileName) == null;
            this.myIsAvailableTimeStamp = current;
        }
        return this.myIsAvailable;
    }

    private void invoke(@NotNull Project project2, PsiDirectory myDirectory) throws IncorrectOperationException {
        block9: {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "invoke"));
            }
            this.myIsAvailableTimeStamp = 0L;
            try {
                if (this.myIsDirectory) {
                    myDirectory.createSubdirectory(this.myNewFileName);
                    break block9;
                }
                String newFileName = this.myNewFileName;
                String newDirectories = null;
                if (this.myNewFileName.contains("/")) {
                    int pos = this.myNewFileName.lastIndexOf("/");
                    newFileName = this.myNewFileName.substring(pos + 1);
                    newDirectories = this.myNewFileName.substring(0, pos);
                }
                PsiDirectory directory = myDirectory;
                if (newDirectories != null) {
                    try {
                        VfsUtil.createDirectoryIfMissing((VirtualFile)myDirectory.getVirtualFile(), newDirectories);
                        VirtualFile vfsDir = VfsUtil.findRelativeFile((VirtualFile)myDirectory.getVirtualFile(), (String[])ArrayUtil.toStringArray((Collection)StringUtil.split(newDirectories, (String)"/")));
                        directory = new PsiDirectoryImpl((PsiManagerImpl)myDirectory.getManager(), vfsDir);
                    }
                    catch (IOException e) {
                        throw new IncorrectOperationException(e.getMessage());
                    }
                }
                PsiFile newFile = directory.createFile(newFileName);
                String text = this.getFileText();
                if (text != null) {
                    FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(newFileName);
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("_" + newFileName, type, (CharSequence)text);
                    PsiElement psiElement = CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)psiFile);
                    text = psiElement.getText();
                }
                this.openFile(project2, directory, newFile, text);
            }
            catch (IncorrectOperationException e) {
                this.myIsAvailable = false;
            }
        }
    }

    protected void openFile(@NotNull Project project2, PsiDirectory directory, PsiFile newFile, String text) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/CreateFileFix", "openFile"));
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)directory.getProject());
        FileEditor[] fileEditors = editorManager.openFile(newFile.getVirtualFile(), true);
        if (text != null) {
            for (FileEditor fileEditor : fileEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document2 = ((TextEditor)fileEditor).getEditor().getDocument();
                document2.setText((CharSequence)text);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    FileDocumentManager.getInstance().saveDocument(document2);
                }
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
                break;
            }
        }
    }
}

