/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.HtmlSelectioner;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.List;

class XmlTokenSelectioner
extends ExtendWordSelectionHandlerBase {
    XmlTokenSelectioner() {
    }

    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof XmlToken && !HtmlSelectioner.canSelectElement(e);
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        XmlToken token = (XmlToken)e;
        if (XmlTokenSelectioner.shouldSelectToken(token)) {
            List<TextRange> ranges = super.select(e, editorText, cursorOffset, editor);
            SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editorText, cursorOffset, ranges);
            return ranges;
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editorText, cursorOffset, result2);
        return result2;
    }

    static boolean shouldSelectToken(XmlToken token) {
        return token.getTokenType() != XmlTokenType.XML_DATA_CHARACTERS && token.getTokenType() != XmlTokenType.XML_START_TAG_START && token.getTokenType() != XmlTokenType.XML_END_TAG_START && token.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END && token.getTokenType() != XmlTokenType.XML_TAG_END;
    }
}

