/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.util.IncorrectOperationException;

public class MissingThrowExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)psiElement;
            if (throwStatement.getException() != null && this.startLine(editor, (PsiElement)throwStatement) == this.startLine(editor, (PsiElement)throwStatement.getException())) {
                return;
            }
            int startOffset = throwStatement.getTextRange().getStartOffset();
            if (throwStatement.getException() != null) {
                editor.getDocument().insertString(startOffset + "throw".length(), (CharSequence)";");
            }
            processor2.registerUnresolvedError(startOffset + "throw".length());
        }
    }

    private int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

