/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;

public class InjectedReferenceSelectioner
extends AbstractWordSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return PsiTreeUtil.getParentOfType((PsiElement)e, PsiLanguageInjectionHost.class) != null;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiReference ref = e.findReferenceAt(cursorOffset - e.getTextRange().getStartOffset());
        if (ref == null) {
            return Collections.emptyList();
        }
        JBIterable it = ref instanceof PsiMultiReference ? JBIterable.of((Object[])((PsiMultiReference)ref).getReferences()) : JBIterable.of((Object)ref);
        return it.transform(ref1 -> {
            TextRange base = ref1.getElement().getTextRange();
            TextRange r = ref1.getRangeInElement().shiftRight(base.getStartOffset());
            return r.containsOffset(cursorOffset) ? r : null;
        }).filter(Conditions.notNull()).toList();
    }
}

