/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaImplementMethodsHandler
implements ContextAwareActionHandler,
LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile) && !(file2 instanceof PsiCodeFragment)) {
            return false;
        }
        return OverrideImplementUtil.getContextClass(file2.getProject(), editor, file2, PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2)) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "invoke"));
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(project2, editor, file2, PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2));
        if (aClass == null) {
            return;
        }
        if (OverrideImplementUtil.getMethodSignaturesToImplement(aClass).isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No methods to implement have been found");
            return;
        }
        OverrideImplementUtil.chooseAndImplementMethods(project2, editor, aClass);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "isAvailableForQuickList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "isAvailableForQuickList"));
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(file2.getProject(), editor, file2, PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2));
        return aClass != null && !OverrideImplementUtil.getMethodSignaturesToImplement(aClass).isEmpty();
    }
}

