/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;

public abstract class ChooseOneOrAllRunnable<T extends PsiElement>
implements Runnable {
    private final T[] myClasses;
    private final Editor myEditor;
    private JList myList;
    private final String myTitle;

    public ChooseOneOrAllRunnable(List<T> classes, Editor editor, String title, Class<T> type) {
        this.myClasses = (PsiElement[])ArrayUtil.toObjectArray(classes, type);
        this.myEditor = editor;
        this.myTitle = title;
    }

    protected abstract void selected(T ... var1);

    @Override
    public void run() {
        if (this.myClasses.length == 1) {
            this.selected((PsiElement[])ArrayUtil.toObjectArray(this.myClasses[0].getClass(), (Object[])new Object[]{this.myClasses[0]}));
        } else if (this.myClasses.length > 0) {
            PsiElementListCellRenderer<T> renderer = this.createRenderer();
            Arrays.sort(this.myClasses, renderer.getComparator());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.selected((PsiElement[])this.myClasses);
                return;
            }
            Vector<T> model = new Vector<T>(Arrays.asList(this.myClasses));
            model.insertElementAt(CodeInsightBundle.message((String)"highlight.thrown.exceptions.chooser.all.entry", (Object[])new Object[0]), 0);
            this.myList = new JBList(model);
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(renderer);
            PopupChooserBuilder builder = new PopupChooserBuilder(this.myList);
            renderer.installSpeedSearch(builder);
            Runnable callback = () -> {
                int idx = this.myList.getSelectedIndex();
                if (idx < 0) {
                    return;
                }
                if (idx > 0) {
                    this.selected((PsiElement[])ArrayUtil.toObjectArray(this.myClasses[idx - 1].getClass(), (Object[])new Object[]{this.myClasses[idx - 1]}));
                } else {
                    this.selected((PsiElement[])this.myClasses);
                }
            };
            ApplicationManager.getApplication().invokeLater(() -> builder.setTitle(this.myTitle).setItemChoosenCallback(callback).createPopup().showInBestPositionFor(this.myEditor));
        }
    }

    protected abstract PsiElementListCellRenderer<T> createRenderer();
}

