/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

public class SplitConditionUtil {
    public static PsiPolyadicExpression findCondition(PsiElement element) {
        return SplitConditionUtil.findCondition(element, true, true);
    }

    public static PsiPolyadicExpression findCondition(PsiElement element, boolean acceptAnd, boolean acceptOr) {
        boolean isOrExpression;
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (!(token.getParent() instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)token.getParent();
        boolean isAndExpression = acceptAnd && expression.getOperationTokenType() == JavaTokenType.ANDAND;
        boolean bl = isOrExpression = acceptOr && expression.getOperationTokenType() == JavaTokenType.OROR;
        if (!isAndExpression && !isOrExpression) {
            return null;
        }
        while (expression.getParent() instanceof PsiPolyadicExpression) {
            expression = (PsiPolyadicExpression)expression.getParent();
            if (isAndExpression && expression.getOperationTokenType() != JavaTokenType.ANDAND) {
                return null;
            }
            if (!isOrExpression || expression.getOperationTokenType() == JavaTokenType.OROR) continue;
            return null;
        }
        return expression;
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression, PsiJavaToken separator) throws IncorrectOperationException {
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)separator, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        int offsetInParent = next == null ? separator.getStartOffsetInParent() + separator.getTextLength() : next.getStartOffsetInParent();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
        String rOperands = expression.getText().substring(offsetInParent);
        return factory.createExpressionFromText(rOperands, expression.getParent());
    }

    public static PsiExpression getLOperands(PsiPolyadicExpression expression, PsiJavaToken separator) throws IncorrectOperationException {
        PsiJavaToken prev = separator;
        if (prev.getPrevSibling() instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev == null) {
            throw new IncorrectOperationException("Unable to split '" + expression.getText() + "' left to '" + separator + "' (offset " + separator.getStartOffsetInParent() + ")");
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
        String rOperands = expression.getText().substring(0, prev.getStartOffsetInParent());
        return factory.createExpressionFromText(rOperands, expression.getParent());
    }
}

