/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.BackspaceHandler;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupTypedHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public abstract class LookupActionHandler
extends EditorActionHandler {
    protected final EditorActionHandler myOriginalHandler;
    private final boolean myRequireFocusedLookup;

    public LookupActionHandler(EditorActionHandler originalHandler, boolean requireFocusedLookup) {
        this.myOriginalHandler = originalHandler;
        this.myRequireFocusedLookup = requireFocusedLookup;
    }

    public boolean executeInCommand(Editor editor, DataContext dataContext) {
        return LookupManager.getActiveLookup(editor) == null;
    }

    public void doExecute(Editor editor, Caret caret, DataContext dataContext) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup == null || !lookup.isAvailableToUser() || this.myRequireFocusedLookup && !lookup.isFocused()) {
            Project project2 = editor.getProject();
            if (project2 != null) {
                LookupManager.getInstance(project2).hideActiveLookup();
            }
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        lookup.markSelectionTouched();
        this.executeInLookup(lookup, dataContext, caret);
    }

    protected abstract void executeInLookup(LookupImpl var1, DataContext var2, @Nullable Caret var3);

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        return lookup != null || this.myOriginalHandler.isEnabled(editor, dataContext);
    }

    private static void executeUpOrDown(LookupImpl lookup, boolean up) {
        if (!lookup.isFocused()) {
            boolean semiFocused = lookup.getFocusDegree() == LookupImpl.FocusDegree.SEMI_FOCUSED;
            lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            if (!up && !semiFocused) {
                return;
            }
        }
        if (up) {
            ScrollingUtil.moveUp((JList)lookup.getList(), (int)0);
        } else {
            ScrollingUtil.moveDown((JList)lookup.getList(), (int)0);
        }
        lookup.markSelectionTouched();
        lookup.refreshUi(false, true);
    }

    public static class RightHandler
    extends LookupActionHandler {
        public RightHandler(EditorActionHandler originalHandler) {
            super(originalHandler, false);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            Editor editor = lookup.getEditor();
            int offset = editor.getCaretModel().getOffset();
            final CharSequence seq = editor.getDocument().getCharsSequence();
            if (seq.length() <= offset || !lookup.isCompletion()) {
                this.myOriginalHandler.execute(editor, caret, context);
                return;
            }
            char c = seq.charAt(offset);
            CharFilter.Result lookupAction = LookupTypedHandler.getLookupAction(c, lookup);
            if (lookupAction != CharFilter.Result.ADD_TO_PREFIX || Character.isWhitespace(c)) {
                this.myOriginalHandler.execute(editor, caret, context);
                return;
            }
            if (!lookup.performGuardedChange(() -> {
                CaretAction action = new CaretAction(){

                    public void perform(Caret caret1) {
                        caret1.removeSelection();
                        int caretOffset = caret1.getOffset();
                        if (caretOffset < seq.length()) {
                            caret1.moveToOffset(caretOffset + 1);
                        }
                    }
                };
                if (caret == null) {
                    editor.getCaretModel().runForEachCaret(action);
                } else {
                    action.perform(caret);
                }
            })) {
                return;
            }
            lookup.appendPrefix(c);
            CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (completion != null) {
                completion.prefixUpdated();
            }
        }
    }

    public static class LeftHandler
    extends LookupActionHandler {
        public LeftHandler(EditorActionHandler originalHandler) {
            super(originalHandler, false);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            if (!lookup.isCompletion()) {
                this.myOriginalHandler.execute(lookup.getEditor(), caret, context);
                return;
            }
            if (!lookup.performGuardedChange(() -> lookup.getEditor().getSelectionModel().removeSelection())) {
                return;
            }
            BackspaceHandler.truncatePrefix(context, lookup, this.myOriginalHandler, lookup.getLookupStart() - 1, caret);
        }
    }

    public static class PageUpHandler
    extends LookupActionHandler {
        public PageUpHandler(EditorActionHandler originalHandler) {
            super(originalHandler, false);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            ScrollingUtil.movePageUp((JList)lookup.getList());
        }
    }

    public static class PageDownHandler
    extends LookupActionHandler {
        public PageDownHandler(EditorActionHandler originalHandler) {
            super(originalHandler, false);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            lookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            ScrollingUtil.movePageDown((JList)lookup.getList());
        }
    }

    public static class UpHandler
    extends LookupActionHandler {
        public UpHandler(EditorActionHandler originalHandler) {
            super(originalHandler, false);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            if (!UISettings.getInstance().CYCLE_SCROLLING && !lookup.isFocused() && lookup.getList().getSelectedIndex() == 0) {
                this.myOriginalHandler.execute(lookup.getEditor(), caret, context);
                return;
            }
            LookupActionHandler.executeUpOrDown(lookup, true);
        }
    }

    public static class DownAction
    extends DumbAwareAction {
        public void actionPerformed(AnActionEvent e) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.cancelByControlArrows");
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)CommonDataKeys.EDITOR.getData(e.getDataContext()));
            assert (lookup != null);
            lookup.hideLookup(true);
            ActionManager.getInstance().getAction("EditorDown").actionPerformed(e);
        }

        public void update(AnActionEvent e) {
            LookupEx lookup = LookupManager.getActiveLookup((Editor)CommonDataKeys.EDITOR.getData(e.getDataContext()));
            e.getPresentation().setEnabled(lookup != null);
        }
    }

    public static class UpAction
    extends DumbAwareAction {
        public void actionPerformed(AnActionEvent e) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.cancelByControlArrows");
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)CommonDataKeys.EDITOR.getData(e.getDataContext()));
            assert (lookup != null) : LookupImpl.getLastLookupDisposeTrace();
            lookup.hideLookup(true);
            ActionManager.getInstance().getAction("EditorUp").actionPerformed(e);
        }

        public void update(AnActionEvent e) {
            LookupEx lookup = LookupManager.getActiveLookup((Editor)CommonDataKeys.EDITOR.getData(e.getDataContext()));
            e.getPresentation().setEnabled(lookup != null);
        }
    }

    public static class DownHandler
    extends LookupActionHandler {
        public DownHandler(EditorActionHandler originalHandler) {
            super(originalHandler, false);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup, DataContext context, Caret caret) {
            LookupActionHandler.executeUpOrDown(lookup, false);
        }
    }
}

