/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl.actions;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.editorActions.ExpandLiveTemplateCustomAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ChooseItemAction
extends EditorAction {
    public ChooseItemAction(Handler handler2) {
        super((EditorActionHandler)handler2);
    }

    public static boolean hasTemplatePrefix(LookupImpl lookup, char shortcutChar) {
        lookup.refreshUi(false, false);
        CompletionProcess completion = CompletionService.getCompletionService().getCurrentCompletion();
        if (completion == null || !completion.isAutopopupCompletion()) {
            return false;
        }
        if (lookup.isSelectionTouched()) {
            return false;
        }
        PsiFile file2 = lookup.getPsiFile();
        if (file2 == null) {
            return false;
        }
        Editor editor = lookup.getEditor();
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        LiveTemplateLookupElement liveTemplateLookup = (LiveTemplateLookupElement)((Object)ContainerUtil.findInstance(lookup.getItems(), LiveTemplateLookupElement.class));
        if (liveTemplateLookup == null || !liveTemplateLookup.sudden) {
            if (LiveTemplateCompletionContributor.customTemplateAvailableAndHasCompletionItem(Character.valueOf(shortcutChar), editor, file2, offset)) {
                return true;
            }
            List<TemplateImpl> templates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(editor, file2, false);
            TemplateImpl template = LiveTemplateCompletionContributor.findFullMatchedApplicableTemplate(editor, offset, templates);
            return template != null && shortcutChar == TemplateSettings.getInstance().getShortcutChar(template);
        }
        return liveTemplateLookup.getTemplateShortcut() == shortcutChar;
    }

    public static class ChooseWithDot
    extends ChooseItemAction {
        public ChooseWithDot() {
            super(new Handler(false, '.'));
        }
    }

    public static class CompletingStatement
    extends ChooseItemAction {
        public CompletingStatement() {
            super(new Handler(true, '\r'));
        }
    }

    public static class Replacing
    extends ChooseItemAction {
        public Replacing() {
            super(new Handler(false, '\t'));
        }
    }

    public static class FocusedOnly
    extends ChooseItemAction {
        public FocusedOnly() {
            super(new Handler(true, '\n'));
        }
    }

    protected static class Handler
    extends EditorActionHandler {
        final boolean focusedOnly;
        final char finishingChar;

        protected Handler(boolean focusedOnly, char finishingChar) {
            this.focusedOnly = focusedOnly;
            this.finishingChar = finishingChar;
        }

        public void execute(@NotNull Editor editor, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/lookup/impl/actions/ChooseItemAction$Handler", "execute"));
            }
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
            if (lookup == null) {
                throw new AssertionError((Object)("The last lookup disposed at: " + LookupImpl.getLastLookupDisposeTrace() + "\n-----------------------\n"));
            }
            if ((this.finishingChar == '\n' || this.finishingChar == '\t') && ChooseItemAction.hasTemplatePrefix(lookup, this.finishingChar)) {
                lookup.hideLookup(true);
                ExpandLiveTemplateCustomAction.createExpandTemplateHandler(this.finishingChar).execute(editor, null, dataContext);
                return;
            }
            if (this.finishingChar == '\n') {
                if (!lookup.isFocused()) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByControlEnter");
                }
            } else if (this.finishingChar == '\r') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishBySmartEnter");
            } else if (this.finishingChar == '\t') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.replace");
            } else if (this.finishingChar == '.') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByCtrlDot");
            }
            lookup.finishLookup(this.finishingChar);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
            if (lookup == null) {
                return false;
            }
            if (!lookup.isAvailableToUser()) {
                return false;
            }
            if (this.focusedOnly && lookup.getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED) {
                return false;
            }
            if (this.finishingChar == '\t') {
                return !lookup.getItems().isEmpty();
            }
            return true;
        }
    }
}

