/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLineStartEndHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;
    private final boolean myIsHomeHandler;
    private final boolean myWithSelection;

    public TemplateLineStartEndHandler(EditorActionHandler originalHandler, boolean isHomeHandler, boolean withSelection) {
        super(true);
        this.myOriginalHandler = originalHandler;
        this.myIsHomeHandler = isHomeHandler;
        this.myWithSelection = withSelection;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/editorActions/TemplateLineStartEndHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/template/impl/editorActions/TemplateLineStartEndHandler", "isEnabledForCaret"));
        }
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            TextRange range = templateState.getCurrentVariableRange();
            int caretOffset = editor.getCaretModel().getOffset();
            if (range != null && range.containsOffset(caretOffset)) {
                return true;
            }
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            TextRange range = templateState.getCurrentVariableRange();
            int caretOffset = editor.getCaretModel().getOffset();
            if (range != null && range.containsOffset(caretOffset)) {
                int selectionOffset = editor.getSelectionModel().getLeadSelectionOffset();
                int offsetToMove = this.myIsHomeHandler ? range.getStartOffset() : range.getEndOffset();
                editor.getCaretModel().moveToOffset(offsetToMove);
                EditorModificationUtil.scrollToCaret((Editor)editor);
                if (this.myWithSelection) {
                    editor.getSelectionModel().setSelection(selectionOffset, offsetToMove);
                } else {
                    editor.getSelectionModel().removeSelection();
                }
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }
}

