/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PostfixTemplateLookupElement
extends CustomLiveTemplateLookupElement {
    @NotNull
    private final PostfixTemplate myTemplate;
    @NotNull
    private final PostfixTemplateProvider myProvider;

    public PostfixTemplateLookupElement(@NotNull PostfixLiveTemplate liveTemplate, @NotNull PostfixTemplate postfixTemplate, @NotNull String templateKey, @NotNull PostfixTemplateProvider provider, boolean sudden) {
        if (liveTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "liveTemplate", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        if (postfixTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixTemplate", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        if (templateKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateKey", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "<init>"));
        }
        super(liveTemplate, templateKey, StringUtil.trimStart((String)templateKey, (String)"."), postfixTemplate.getDescription(), sudden, true);
        this.myTemplate = postfixTemplate;
        this.myProvider = provider;
    }

    @NotNull
    public PostfixTemplate getPostfixTemplate() {
        PostfixTemplate postfixTemplate = this.myTemplate;
        if (postfixTemplate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "getPostfixTemplate"));
        }
        return postfixTemplate;
    }

    @NotNull
    public PostfixTemplateProvider getProvider() {
        PostfixTemplateProvider postfixTemplateProvider = this.myProvider;
        if (postfixTemplateProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupElement", "getProvider"));
        }
        return postfixTemplateProvider;
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        if (this.sudden) {
            presentation.setTailText(" " + UIUtil.rightArrow() + " " + this.myTemplate.getExample());
        } else {
            presentation.setTypeText(this.myTemplate.getExample());
            presentation.setTypeGrayed(true);
        }
    }
}

