/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.util.SingletonSet;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

final class CombinedAnalysis {
    private final ControlFlowGraph controlFlow;
    private final Method method;
    private final CombinedInterpreter interpreter;
    private BasicValue returnValue;
    private boolean exception;
    private final MethodNode methodNode;

    CombinedAnalysis(Method method, ControlFlowGraph controlFlow) {
        this.method = method;
        this.controlFlow = controlFlow;
        this.methodNode = controlFlow.methodNode;
        this.interpreter = new CombinedInterpreter(this.methodNode.instructions, Type.getArgumentTypes((String)this.methodNode.desc).length);
    }

    final void analyze() throws AnalyzerException {
        Frame<BasicValue> frame = this.createStartFrame();
        int insnIndex = 0;
        block8: while (true) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    insnIndex = this.controlFlow.transitions[insnIndex][0];
                    continue block8;
                }
            }
            switch (insnNode.getOpcode()) {
                case 191: {
                    this.exception = true;
                    return;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.returnValue = (BasicValue)frame.pop();
                    return;
                }
                case 177: {
                    return;
                }
            }
            frame.execute(insnNode, (Interpreter)this.interpreter);
            insnIndex = this.controlFlow.transitions[insnIndex][0];
        }
    }

    final Equation notNullParamEquation(int i, boolean stable) {
        Result result2;
        Key key2 = new Key(this.method, new Direction.In(i, 0), stable);
        if (this.interpreter.dereferencedParams[i]) {
            result2 = new Final(Value.NotNull);
        } else {
            Set<CombinedData.ParamKey> calls = this.interpreter.parameterFlow[i];
            if (calls == null || calls.isEmpty()) {
                result2 = new Final(Value.Top);
            } else {
                HashSet keys = new HashSet();
                for (CombinedData.ParamKey pk : calls) {
                    keys.add(new Key(pk.method, new Direction.In(pk.i, 0), pk.stable));
                }
                result2 = new Pending((Set<Product>)new SingletonSet((Object)new Product(Value.Top, (Set<Key>)keys)));
            }
        }
        return new Equation(key2, result2);
    }

    final Equation nullableParamEquation(int i, boolean stable) {
        Result result2;
        Key key2 = new Key(this.method, new Direction.In(i, 1), stable);
        if (this.interpreter.dereferencedParams[i] || this.interpreter.notNullableParams[i] || this.returnValue instanceof CombinedData.NthParamValue && ((CombinedData.NthParamValue)this.returnValue).n == i) {
            result2 = new Final(Value.Top);
        } else {
            Set<CombinedData.ParamKey> calls = this.interpreter.parameterFlow[i];
            if (calls == null || calls.isEmpty()) {
                result2 = new Final(Value.Null);
            } else {
                HashSet sum = new HashSet();
                for (CombinedData.ParamKey pk : calls) {
                    sum.add(new Product(Value.Top, Collections.singleton(new Key(pk.method, new Direction.In(pk.i, 1), pk.stable))));
                }
                result2 = new Pending((Set<Product>)sum);
            }
        }
        return new Equation(key2, result2);
    }

    final Equation contractEquation(int i, Value inValue, boolean stable) {
        Result result2;
        Key key2 = new Key(this.method, new Direction.InOut(i, inValue), stable);
        if (this.exception || inValue == Value.Null && this.interpreter.dereferencedParams[i]) {
            result2 = new Final(Value.Bot);
        } else if (AbstractValues.FalseValue == this.returnValue) {
            result2 = new Final(Value.False);
        } else if (AbstractValues.TrueValue == this.returnValue) {
            result2 = new Final(Value.True);
        } else if (this.returnValue instanceof CombinedData.TrackableNullValue) {
            result2 = new Final(Value.Null);
        } else if (this.returnValue instanceof AbstractValues.NotNullValue || CombinedData.ThisValue == this.returnValue) {
            result2 = new Final(Value.NotNull);
        } else if (this.returnValue instanceof CombinedData.NthParamValue && ((CombinedData.NthParamValue)this.returnValue).n == i) {
            result2 = new Final(inValue);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            HashSet keys = new HashSet();
            for (int argI = 0; argI < call.args.size(); ++argI) {
                BasicValue arg = call.args.get(argI);
                if (!(arg instanceof CombinedData.NthParamValue)) continue;
                CombinedData.NthParamValue npv = (CombinedData.NthParamValue)arg;
                if (npv.n != i) continue;
                keys.add((Object)new Key(call.method, new Direction.InOut(argI, inValue), call.stableCall));
            }
            if (ASMUtils.isReferenceType(call.getType())) {
                keys.add((Object)new Key(call.method, Direction.Out, call.stableCall));
            }
            result2 = keys.isEmpty() ? new Final(Value.Top) : new Pending((Set<Product>)new SingletonSet((Object)new Product(Value.Top, (Set<Key>)keys)));
        } else {
            result2 = new Final(Value.Top);
        }
        return new Equation(key2, result2);
    }

    final Equation outContractEquation(boolean stable) {
        Result result2;
        Key key2 = new Key(this.method, Direction.Out, stable);
        if (this.exception) {
            result2 = new Final(Value.Bot);
        } else if (AbstractValues.FalseValue == this.returnValue) {
            result2 = new Final(Value.False);
        } else if (AbstractValues.TrueValue == this.returnValue) {
            result2 = new Final(Value.True);
        } else if (this.returnValue instanceof CombinedData.TrackableNullValue) {
            result2 = new Final(Value.Null);
        } else if (this.returnValue instanceof AbstractValues.NotNullValue || this.returnValue == CombinedData.ThisValue) {
            result2 = new Final(Value.NotNull);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            Key callKey = new Key(call.method, Direction.Out, call.stableCall);
            SingletonSet keys = new SingletonSet((Object)callKey);
            result2 = new Pending((Set<Product>)new SingletonSet((Object)new Product(Value.Top, (Set<Key>)keys)));
        } else {
            result2 = new Final(Value.Top);
        }
        return new Equation(key2, result2);
    }

    final Equation nullableResultEquation(boolean stable) {
        Result result2;
        Key key2 = new Key(this.method, Direction.NullableOut, stable);
        if (this.exception || this.returnValue instanceof CombinedData.Trackable && this.interpreter.dereferencedValues[((CombinedData.Trackable)this.returnValue).getOriginInsnIndex()]) {
            result2 = new Final(Value.Bot);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            Key callKey = new Key(call.method, Direction.NullableOut, call.stableCall || call.thisCall);
            SingletonSet keys = new SingletonSet((Object)callKey);
            result2 = new Pending((Set<Product>)new SingletonSet((Object)new Product(Value.Null, (Set<Key>)keys)));
        } else {
            result2 = this.returnValue instanceof CombinedData.TrackableNullValue ? new Final(Value.Null) : new Final(Value.Bot);
        }
        return new Equation(key2, result2);
    }

    final Frame<BasicValue> createStartFrame() {
        Frame frame = new Frame(this.methodNode.maxLocals, this.methodNode.maxStack);
        Type returnType = Type.getReturnType((String)this.methodNode.desc);
        BasicValue returnValue = Type.VOID_TYPE.equals((Object)returnType) ? null : new BasicValue(returnType);
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)returnValue);
        Type[] args = Type.getArgumentTypes((String)this.methodNode.desc);
        int local = 0;
        if ((this.methodNode.access & 8) == 0) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)CombinedData.ThisValue);
        }
        for (int i = 0; i < args.length; ++i) {
            CombinedData.NthParamValue value = new CombinedData.NthParamValue(args[i], i);
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value);
            if (args[i].getSize() != 2) continue;
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        while (local < this.methodNode.maxLocals) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        return frame;
    }
}

