/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveExtraClosingTagIntentionAction
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null || !psiElement.isValid() || !(psiElement instanceof XmlToken)) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(psiElement);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void doFix(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "doFix"));
        }
        XmlToken endNameToken = (XmlToken)element;
        PsiElement tagElement = endNameToken.getParent();
        if (!(tagElement instanceof XmlTag) && !(tagElement instanceof PsiErrorElement)) {
            return;
        }
        if (tagElement instanceof PsiErrorElement) {
            tagElement.delete();
        } else {
            Document document2;
            ASTNode endTagStart;
            ASTNode astNode = tagElement.getNode();
            if (astNode != null && (endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(astNode)) != null && (document2 = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(tagElement.getContainingFile())) != null) {
                document2.deleteString(endTagStart.getStartOffset(), tagElement.getLastChild().getTextRange().getEndOffset());
            }
        }
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction", "applyFix"));
        }
        final PsiElement element = descriptor.getPsiElement();
        if (!element.isValid() || !(element instanceof XmlToken)) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        new WriteCommandAction(project2, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction$1", "run"));
                }
                RemoveExtraClosingTagIntentionAction.doFix(element);
            }
        }.execute();
    }
}

