/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.compiler.actions.GenerateAntBuildDialog;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationOptionsImpl;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.ModuleChunkAntProject;
import com.intellij.compiler.ant.MultipleFileProjectBuild;
import com.intellij.compiler.ant.PropertyFileGeneratorImpl;
import com.intellij.compiler.ant.SingleFileProjectBuild;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateAntBuildAction
extends CompileActionBase {
    @NonNls
    private static final String XML_EXTENSION = ".xml";

    @Override
    protected void doAction(DataContext dataContext, final Project project2) {
        ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2)).convertPatterns();
        final GenerateAntBuildDialog dialog = new GenerateAntBuildDialog(project2);
        if (dialog.showAndGet()) {
            final String[] names = dialog.getRepresentativeModuleNames();
            GenerationOptionsImpl[] genOptions = new GenerationOptionsImpl[1];
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                genOptions[0] = (GenerationOptionsImpl)((Object)((Object)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GenerationOptionsImpl>(){

                    public GenerationOptionsImpl compute() {
                        return new GenerationOptionsImpl(project2, dialog.isGenerateSingleFileBuild(), dialog.isFormsCompilationEnabled(), dialog.isBackupFiles(), dialog.isForceTargetJdk(), dialog.isRuntimeClasspathInlined(), dialog.isIdeaHomeGenerated(), names, dialog.getOutputFileName());
                    }
                })));
            }, "Analyzing project structure...", true, project2)) {
                return;
            }
            if (!GenerateAntBuildAction.validateGenOptions(project2, genOptions[0])) {
                return;
            }
            this.generate(project2, genOptions[0]);
        }
    }

    private static boolean validateGenOptions(Project project2, GenerationOptionsImpl genOptions) {
        List<String> EMPTY;
        List<String> conflicts = EMPTY = Collections.emptyList();
        for (ModuleChunk chunk : genOptions.getModuleChunks()) {
            ChunkCustomCompilerExtension[] customeCompilers = chunk.getCustomCompilers();
            if (customeCompilers.length <= 1) continue;
            if (conflicts == EMPTY) {
                conflicts = new LinkedList<String>();
            }
            conflicts.add(chunk.getName());
        }
        if (!conflicts.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (String conflictingChunk : conflicts) {
                msg.append(CompilerBundle.message((String)"generate.ant.build.custom.compiler.conflict.message.row", (Object[])new Object[]{conflictingChunk}));
            }
            int rc = Messages.showOkCancelDialog((Project)project2, (String)CompilerBundle.message((String)"generate.ant.build.custom.compiler.conflict.message", (Object[])new Object[]{msg.toString()}), (String)CompilerBundle.message((String)"generate.ant.build.custom.compiler.conflict.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            if (rc != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(e.getProject() != null);
    }

    private void generate(final Project project2, final GenerationOptions genOptions) {
        ApplicationManager.getApplication().saveAll();
        final ArrayList<File> filesToRefresh = new ArrayList<File>();
        final IOException[] _ex = new IOException[]{null};
        final ArrayList _generated = new ArrayList();
        try {
            if (genOptions.generateSingleFile) {
                File projectBuildFileDestDir = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
                File destFile = new File(projectBuildFileDestDir, genOptions.getBuildFileName());
                File propertiesFile = new File(projectBuildFileDestDir, genOptions.getPropertiesFileName());
                this.ensureFilesWritable(project2, new File[]{destFile, propertiesFile});
            } else {
                ModuleChunk[] chunks;
                ArrayList<File> allFiles = new ArrayList<File>();
                File projectBuildFileDestDir = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
                allFiles.add(new File(projectBuildFileDestDir, genOptions.getBuildFileName()));
                allFiles.add(new File(projectBuildFileDestDir, genOptions.getPropertiesFileName()));
                for (ModuleChunk chunk : chunks = genOptions.getModuleChunks()) {
                    File chunkBaseDir = BuildProperties.getModuleChunkBaseDir((ModuleChunk)chunk);
                    allFiles.add(new File(chunkBaseDir, BuildProperties.getModuleChunkBuildFileName((ModuleChunk)chunk) + XML_EXTENSION));
                }
                this.ensureFilesWritable(project2, allFiles.toArray(new File[allFiles.size()]));
            }
            new Task.Modal(project2, CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/compiler/actions/GenerateAntBuildAction$2", "run"));
                    }
                    indicator.setIndeterminate(true);
                    indicator.setText(CompilerBundle.message((String)"generate.ant.build.progress.message", (Object[])new Object[0]));
                    try {
                        Object[] generated = genOptions.generateSingleFile ? GenerateAntBuildAction.this.generateSingleFileBuild(project2, genOptions, filesToRefresh) : GenerateAntBuildAction.this.generateMultipleFileBuild(project2, genOptions, filesToRefresh);
                        if (generated != null) {
                            ContainerUtil.addAll((Collection)_generated, (Object[])generated);
                        }
                    }
                    catch (IOException e) {
                        _ex[0] = e;
                    }
                }
            }.queue();
        }
        catch (IOException e) {
            _ex[0] = e;
        }
        if (_ex[0] != null) {
            Messages.showErrorDialog((Project)project2, (String)CompilerBundle.message((String)"error.ant.files.generate.failed", (Object[])new Object[]{_ex[0].getMessage()}), (String)CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]));
        } else {
            StringBuffer filesString = new StringBuffer();
            for (int idx = 0; idx < _generated.size(); ++idx) {
                File file2 = (File)_generated.get(idx);
                if (idx > 0) {
                    filesString.append(",\n");
                }
                filesString.append(file2.getPath());
            }
            Messages.showInfoMessage((Project)project2, (String)CompilerBundle.message((String)"message.ant.files.generated.ok", (Object[])new Object[]{filesString.toString()}), (String)CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]));
        }
        if (filesToRefresh.size() > 0) {
            CompilerUtil.refreshIOFiles(filesToRefresh);
        }
    }

    private boolean backup(File file2, Project project2, GenerationOptions genOptions, List<File> filesToRefresh) {
        boolean ok;
        if (!genOptions.backupPreviouslyGeneratedFiles || !file2.exists()) {
            return true;
        }
        String path = file2.getPath();
        int extensionIndex = path.lastIndexOf(".");
        String extension = path.substring(extensionIndex, path.length());
        String backupPath = path.substring(0, extensionIndex) + "_" + new Date(file2.lastModified()).toString().replaceAll("\\s+", "_").replaceAll(":", "-") + extension;
        File backupFile = new File(backupPath);
        try {
            FileUtil.rename((File)file2, (File)backupFile);
            ok = true;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project2, (String)CompilerBundle.message((String)"error.ant.files.backup.failed", (Object[])new Object[]{path}), (String)CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]));
            ok = false;
        }
        filesToRefresh.add(backupFile);
        return ok;
    }

    private File[] generateSingleFileBuild(Project project2, GenerationOptions genOptions, List<File> filesToRefresh) throws IOException {
        File projectBuildFileDestDir = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
        projectBuildFileDestDir.mkdirs();
        File destFile = new File(projectBuildFileDestDir, genOptions.getBuildFileName());
        File propertiesFile = new File(projectBuildFileDestDir, genOptions.getPropertiesFileName());
        if (!this.backup(destFile, project2, genOptions, filesToRefresh)) {
            return null;
        }
        if (!this.backup(propertiesFile, project2, genOptions, filesToRefresh)) {
            return null;
        }
        GenerateAntBuildAction.generateSingleFileBuild(project2, genOptions, destFile, propertiesFile);
        filesToRefresh.add(destFile);
        filesToRefresh.add(propertiesFile);
        return new File[]{destFile, propertiesFile};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSingleFileBuild(Project project2, GenerationOptions genOptions, File buildxmlFile, File propertiesFile) throws IOException {
        FileUtil.createIfDoesntExist((File)buildxmlFile);
        FileUtil.createIfDoesntExist((File)propertiesFile);
        try (PrintWriter dataOutput = GenerateAntBuildAction.makeWriter(buildxmlFile);){
            new SingleFileProjectBuild(project2, genOptions).generate(dataOutput);
        }
        try (PrintWriter propertiesOut = GenerateAntBuildAction.makeWriter(propertiesFile);){
            new PropertyFileGeneratorImpl(project2, genOptions).generate(propertiesOut);
        }
    }

    private static PrintWriter makeWriter(File buildxmlFile) throws UnsupportedEncodingException, FileNotFoundException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(buildxmlFile), CharsetToolkit.UTF8_CHARSET));
    }

    private void ensureFilesWritable(Project project2, File[] files) throws IOException {
        ArrayList<VirtualFile> toCheck = new ArrayList<VirtualFile>(files.length);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (File file2 : files) {
            VirtualFile vFile = lfs.findFileByIoFile(file2);
            if (vFile == null) continue;
            toCheck.add(vFile);
        }
        ReadonlyStatusHandler.OperationStatus status2 = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(VfsUtil.toVirtualFileArray(toCheck));
        if (status2.hasReadonlyFiles()) {
            throw new IOException(status2.getReadonlyFilesMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] generateMultipleFileBuild(Project project2, GenerationOptions genOptions, List<File> filesToRefresh) throws IOException {
        File projectBuildFileDestDir = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
        projectBuildFileDestDir.mkdirs();
        ArrayList<File> generated = new ArrayList<File>();
        File projectBuildFile = new File(projectBuildFileDestDir, genOptions.getBuildFileName());
        File propertiesFile = new File(projectBuildFileDestDir, genOptions.getPropertiesFileName());
        ModuleChunk[] chunks = genOptions.getModuleChunks();
        File[] chunkFiles = new File[chunks.length];
        for (int idx = 0; idx < chunks.length; ++idx) {
            ModuleChunk chunk = chunks[idx];
            File chunkBaseDir = BuildProperties.getModuleChunkBaseDir((ModuleChunk)chunk);
            chunkFiles[idx] = new File(chunkBaseDir, BuildProperties.getModuleChunkBuildFileName((ModuleChunk)chunk) + XML_EXTENSION);
        }
        if (!this.backup(projectBuildFile, project2, genOptions, filesToRefresh)) {
            return null;
        }
        if (!this.backup(propertiesFile, project2, genOptions, filesToRefresh)) {
            return null;
        }
        FileUtil.createIfDoesntExist((File)projectBuildFile);
        try (PrintWriter mainDataOutput = GenerateAntBuildAction.makeWriter(projectBuildFile);){
            MultipleFileProjectBuild build = new MultipleFileProjectBuild(project2, genOptions);
            build.generate(mainDataOutput);
            generated.add(projectBuildFile);
            for (int idx = 0; idx < chunks.length; ++idx) {
                boolean moduleBackupOk;
                ModuleChunk chunk = chunks[idx];
                File chunkBuildFile = chunkFiles[idx];
                File chunkBaseDir = chunkBuildFile.getParentFile();
                if (chunkBaseDir != null) {
                    chunkBaseDir.mkdirs();
                }
                if (!(moduleBackupOk = this.backup(chunkBuildFile, project2, genOptions, filesToRefresh))) {
                    File[] fileArray = null;
                    return fileArray;
                }
                FileUtil.createIfDoesntExist((File)chunkBuildFile);
                try (PrintWriter out = GenerateAntBuildAction.makeWriter(chunkBuildFile);){
                    new ModuleChunkAntProject(project2, chunk, genOptions).generate(out);
                    generated.add(chunkBuildFile);
                    continue;
                }
            }
        }
        try (PrintWriter propertiesOut = GenerateAntBuildAction.makeWriter(propertiesFile);){
            new PropertyFileGeneratorImpl(project2, genOptions).generate(propertiesOut);
            generated.add(propertiesFile);
        }
        filesToRefresh.addAll(generated);
        return generated.toArray(new File[generated.size()]);
    }
}

