/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultiFilesSettings {
    private SettingsXmlFile myProjectFile;
    private final List<SettingsXmlFile> mySettingsFiles;

    protected MultiFilesSettings(@Nullable File projectFile, @Nullable File[] settingsFiles, @NotNull ConversionContextImpl context) throws CannotConvertException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/conversion/impl/MultiFilesSettings", "<init>"));
        }
        if (projectFile == null && settingsFiles == null) {
            throw new IllegalArgumentException("Either project file or settings files should be not null");
        }
        if (projectFile != null && projectFile.exists()) {
            this.myProjectFile = context.getOrCreateFile(projectFile);
        }
        this.mySettingsFiles = new ArrayList<SettingsXmlFile>();
        if (settingsFiles != null) {
            for (File file2 : settingsFiles) {
                this.mySettingsFiles.add(context.getOrCreateFile(file2));
            }
        }
    }

    @NotNull
    protected Collection<? extends Element> getSettings(@NotNull String componentName, @NotNull String tagName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/conversion/impl/MultiFilesSettings", "getSettings"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/conversion/impl/MultiFilesSettings", "getSettings"));
        }
        ArrayList result2 = new ArrayList();
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myProjectFile.findComponent(componentName), (String)tagName));
        }
        for (SettingsXmlFile file2 : this.mySettingsFiles) {
            result2.addAll(JDOMUtil.getChildren((Element)file2.getRootElement(), (String)tagName));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/conversion/impl/MultiFilesSettings", "getSettings"));
        }
        return arrayList;
    }

    public Collection<File> getAffectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.myProjectFile != null) {
            files.add(this.myProjectFile.getFile());
        }
        for (SettingsXmlFile file2 : this.mySettingsFiles) {
            files.add(file2.getFile());
        }
        return files;
    }
}

