/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean myInitialized;
    @Nullable
    private final DebuggerSession myDebuggerSession;
    private final SuspendContextImpl mySuspendContext;
    private final ThreadReferenceProxyImpl myThreadProxy;
    private StackFrameProxyImpl myFrameProxy;
    private SourcePosition mySourcePosition;
    private PsiElement myContextElement;

    private DebuggerContextImpl(@Nullable DebuggerSession session2, @Nullable SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy, SourcePosition position, PsiElement contextElement, boolean initialized) {
        LOG.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        this.myDebuggerSession = session2;
        this.myThreadProxy = threadProxy;
        this.myFrameProxy = frameProxy;
        this.mySourcePosition = position;
        this.mySuspendContext = context;
        this.myContextElement = contextElement;
        this.myInitialized = initialized;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.myThreadProxy;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public Project getProject() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        LOG.assertTrue(this.myInitialized);
        return this.myFrameProxy;
    }

    public SourcePosition getSourcePosition() {
        LOG.assertTrue(this.myInitialized);
        return this.mySourcePosition;
    }

    public PsiElement getContextElement() {
        LOG.assertTrue(this.myInitialized);
        PsiElement contextElement = this.myContextElement;
        if (contextElement != null && !contextElement.isValid()) {
            this.myContextElement = ContextUtil.getContextElement(this.mySourcePosition);
        }
        return this.myContextElement;
    }

    public EvaluationContextImpl createEvaluationContext(Value thisObject) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), thisObject);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        ObjectReference objectReference;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        StackFrameProxyImpl frameProxy = this.getFrameProxy();
        try {
            objectReference = frameProxy != null ? frameProxy.thisObject() : null;
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            objectReference = null;
        }
        SuspendContextImpl context = this.getSuspendContext();
        return context != null ? new EvaluationContextImpl(context, frameProxy, objectReference) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession session2, @Nullable SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy) {
        LOG.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        DebuggerContextImpl debuggerContextImpl = new DebuggerContextImpl(session2, context, threadProxy, frameProxy, null, null, context == null);
        if (debuggerContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextImpl", "createDebuggerContext"));
        }
        return debuggerContextImpl;
    }

    public void initCaches() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        if (this.myFrameProxy == null && this.myThreadProxy != null) {
            try {
                this.myFrameProxy = this.myThreadProxy.frameCount() > 0 ? this.myThreadProxy.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.myFrameProxy != null) {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAndRunReadAction(() -> {
                if (this.mySourcePosition == null) {
                    this.mySourcePosition = ContextUtil.getSourcePosition((StackFrameContext)this);
                }
                this.myContextElement = ContextUtil.getContextElement(this.mySourcePosition);
            });
        }
    }

    public void setPositionCache(SourcePosition position) {
        this.mySourcePosition = position;
    }

    public boolean isInitialised() {
        return this.myInitialized;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess != null && debugProcess.getSuspendManager().getPausedContext() != null;
    }
}

