/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public class UserExpressionDescriptorImpl
extends EvaluationDescriptor
implements UserExpressionDescriptor {
    private final ValueDescriptorImpl myParentDescriptor;
    private final String myTypeName;
    private final String myName;

    public UserExpressionDescriptorImpl(Project project2, ValueDescriptorImpl parent, String typeName, String name, TextWithImports text) {
        super(text, project2);
        this.myParentDescriptor = parent;
        this.myTypeName = typeName;
        this.myName = name;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        Type type = this.getType();
        return type != null ? type.name() : null;
    }

    @Override
    protected PsiCodeFragment getEvaluationCode(StackFrameContext context) throws EvaluateException {
        Value value = this.myParentDescriptor.getValue();
        if (value instanceof ObjectReference) {
            String typeName = value.type().name();
            PsiClass psiClass = DebuggerUtils.findClass((String)this.myTypeName, (Project)this.myProject, (GlobalSearchScope)context.getDebugProcess().getSearchScope());
            if (psiClass == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.type.name", (Object[])new Object[]{typeName}));
            }
            return this.createCodeFragment((PsiElement)psiClass);
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.objref.expected", (Object[])new Object[]{this.myParentDescriptor.getName()}));
    }

    public ValueDescriptorImpl getParentDescriptor() {
        return this.myParentDescriptor;
    }

    @Override
    protected EvaluationContextImpl getEvaluationContext(EvaluationContextImpl evaluationContext) {
        return evaluationContext.createEvaluationContext(this.myParentDescriptor.getValue());
    }
}

