/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolWindowManager
extends LightToolWindowManager {
    protected AbstractToolWindowManager(Project project2, FileEditorManager fileEditorManager) {
        super(project2, fileEditorManager);
    }

    @Override
    @Nullable
    protected DesignerEditorPanelFacade getDesigner(FileEditor editor) {
        if (editor instanceof DesignerEditor) {
            DesignerEditor designerEditor = (DesignerEditor)editor;
            return designerEditor.getDesignerPanel();
        }
        return null;
    }

    @Override
    protected ToggleEditorModeAction createToggleAction(ToolWindowAnchor anchor) {
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            @Override
            protected LightToolWindowManager getOppositeManager() {
                DesignerToolWindowManager designerManager = DesignerToolWindowManager.getInstance(this.myProject);
                PaletteToolWindowManager paletteManager = PaletteToolWindowManager.getInstance(this.myProject);
                return this.myManager == designerManager ? paletteManager : designerManager;
            }
        };
    }

    @Nullable
    protected static DesignerCustomizations getCustomizations() {
        return (DesignerCustomizations)DesignerCustomizations.EP_NAME.findExtension(DesignerCustomizations.class);
    }
}

