/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.MergeInnerDifferences;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    public static final Logger LOG = Logger.getInstance(SimpleThreesideDiffViewer.class);
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyEditorReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_BASE));
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.BASE_RIGHT));
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createPopupActions"));
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            List contents = this.myRequest.getContents();
            List documents = ContainerUtil.map((Collection)contents, content -> ((DocumentContent)content).getDocument());
            List sequences = (List)ReadAction.compute(() -> {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "lambda$performRediff$1"));
                }
                indicator.checkCanceled();
                return ContainerUtil.map((Collection)documents, Document::getImmutableCharSequence);
            });
            ComparisonPolicy comparisonPolicy = this.getIgnorePolicy().getComparisonPolicy();
            List<MergeLineFragment> lineFragments = ByLine.compareTwoStep((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), comparisonPolicy, indicator);
            List conflictTypes = (List)ReadAction.compute(() -> {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "lambda$performRediff$3"));
                }
                indicator.checkCanceled();
                return ContainerUtil.map((Collection)lineFragments, fragment -> DiffUtil.getLineMergeType(fragment, documents, comparisonPolicy));
            });
            ArrayList<MergeInnerDifferences> innerFragments = null;
            if (this.getHighlightPolicy().isFineFragments()) {
                innerFragments = new ArrayList<MergeInnerDifferences>(lineFragments.size());
                for (int i = 0; i < lineFragments.size(); ++i) {
                    MergeLineFragment fragment = lineFragments.get(i);
                    MergeConflictType conflictType = (MergeConflictType)conflictTypes.get(i);
                    List chunks = (List)ReadAction.compute(() -> {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "lambda$performRediff$5"));
                        }
                        indicator.checkCanceled();
                        return ThreeSide.map(side -> {
                            if (!conflictType.isChange((ThreeSide)side)) {
                                return null;
                            }
                            return SimpleThreesideDiffViewer.getChunkContent(fragment, documents, side);
                        });
                    });
                    innerFragments.add(DiffUtil.compareThreesideInner(chunks, comparisonPolicy, indicator));
                }
            }
            runnable2 = this.apply(lineFragments, conflictTypes, innerFragments);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        return runnable2;
    }

    @Nullable
    private static CharSequence getChunkContent(@NotNull MergeLineFragment fragment, @NotNull List<Document> documents, @NotNull ThreeSide side) {
        int endLine;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChunkContent"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChunkContent"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChunkContent"));
        }
        int startLine = fragment.getStartLine(side);
        return startLine != (endLine = fragment.getEndLine(side)) ? DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine) : null;
    }

    @NotNull
    private Runnable apply(@NotNull List<MergeLineFragment> fragments, @NotNull List<MergeConflictType> conflictTypes, @Nullable List<MergeInnerDifferences> innerDifferences) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        if (conflictTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictTypes", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        Runnable runnable2 = () -> {
            if (fragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "lambda$apply$6"));
            }
            if (conflictTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictTypes", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "lambda$apply$6"));
            }
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            for (int i = 0; i < fragments.size(); ++i) {
                MergeLineFragment fragment = (MergeLineFragment)fragments.get(i);
                MergeConflictType conflictType = (MergeConflictType)conflictTypes.get(i);
                MergeInnerDifferences innerFragments = innerDifferences != null ? (MergeInnerDifferences)innerDifferences.get(i) : null;
                SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, conflictType, innerFragments, this);
                this.myDiffChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(fragments, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        return runnable2;
    }

    @Override
    protected void destroyChangedBlocks() {
        super.destroyChangedBlocks();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroy();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroy();
        }
        this.myInvalidDiffChanges.clear();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        ThreeSide side = ThreeSide.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @NotNull
    private IgnorePolicy getIgnorePolicy() {
        IgnorePolicy policy = this.getTextSettings().getIgnorePolicy();
        if (policy == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
            IgnorePolicy ignorePolicy = IgnorePolicy.IGNORE_WHITESPACES;
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getIgnorePolicy"));
            }
            return ignorePolicy;
        }
        IgnorePolicy ignorePolicy = policy;
        if (ignorePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getIgnorePolicy"));
        }
        return ignorePolicy;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy policy = this.getTextSettings().getHighlightPolicy();
        if (policy == HighlightPolicy.BY_WORD_SPLIT) {
            HighlightPolicy highlightPolicy = HighlightPolicy.BY_WORD;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }
        if (policy == HighlightPolicy.DO_NOT_HIGHLIGHT) {
            HighlightPolicy highlightPolicy = HighlightPolicy.BY_LINE;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }
        HighlightPolicy highlightPolicy = policy;
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        List<SimpleThreesideDiffChange> list = this.myDiffChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDividerPaintable"));
        }
        MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
        if (myDividerPaintable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDividerPaintable"));
        }
        return myDividerPaintable;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request);
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        public MyDividerPaintable(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "process"));
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler2.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor(SimpleThreesideDiffViewer.this.getEditor(ThreeSide.BASE)))) continue;
                return;
            }
        }
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction() {
            super(SimpleThreesideDiffViewer.this.getContext(), SimpleThreesideDiffViewer.this.getEditableEditors());
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        public MyHighlightPolicySettingAction() {
            super(SimpleThreesideDiffViewer.this.getTextSettings());
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            HighlightPolicy highlightPolicy = SimpleThreesideDiffViewer.this.getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyHighlightPolicySettingAction", "getCurrentSetting"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            List list = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyHighlightPolicySettingAction", "getAvailableSettings"));
            }
            return list;
        }

        @Override
        protected void onSettingsChanged() {
            SimpleThreesideDiffViewer.this.rediff();
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        public MyIgnorePolicySettingAction() {
            super(SimpleThreesideDiffViewer.this.getTextSettings());
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = SimpleThreesideDiffViewer.this.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyIgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])IgnorePolicy.values());
            settings.remove((Object)IgnorePolicy.IGNORE_WHITESPACES_CHUNKS);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyIgnorePolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }

        @Override
        protected void onSettingsChanged() {
            SimpleThreesideDiffViewer.this.rediff();
        }
    }
}

