/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.MergeInnerDifferences;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    @NotNull
    public static final String DIFF_CONFIG = "diff.xml";
    public static final int TITLE_GAP = JBUI.scale((int)2);

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isDiffEditor"));
        }
        return editor.getUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY) != null;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project2, @NotNull DocumentContent content, @NotNull CharSequence text) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project2, content);
        if (highlighter == null) {
            return null;
        }
        highlighter.setText(text);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text);
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Nullable
    private static EditorHighlighter createEditorHighlighter(@Nullable Project project2, @NotNull DocumentContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createEditorHighlighter"));
        }
        FileType type = content.getContentType();
        VirtualFile file2 = content.getHighlightFile();
        Language language = (Language)content.getUserData(DiffUserDataKeys.LANGUAGE);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        if (language != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)file2);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (file2 != null && (type == null || type == PlainTextFileType.INSTANCE || file2.getFileType() == type || file2 instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project2, file2);
        }
        if (type != null) {
            return highlighterFactory.createEditorHighlighter(project2, type);
        }
        return null;
    }

    @NotNull
    private static EditorHighlighter createEmptyEditorHighlighter() {
        EmptyEditorHighlighter emptyEditorHighlighter = new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
        if (emptyEditorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEmptyEditorHighlighter"));
        }
        return emptyEditorHighlighter;
    }

    public static void setEditorHighlighter(@Nullable Project project2, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project2, content);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project2, @NotNull EditorEx editor, @Nullable FileType fileType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorCodeStyle"));
        }
        if (project2 != null && fileType != null) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project2);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setFoldingModelSupport"));
        }
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document2, @Nullable Project project2, boolean isViewer) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorEx editorEx = DiffUtil.createEditor(document2, project2, isViewer, false);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document2, @Nullable Project project2, boolean isViewer, boolean enableFolding) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document2, project2) : factory.createEditor(document2, project2));
        editor.putUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY, Boolean.TRUE);
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content, @Nullable Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        DiffUtil.setEditorHighlighter(project2, editor, content);
        DiffUtil.setEditorCodeStyle(project2, editor, content.getContentType());
        editor.reinitSettings();
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isMirrored"));
        }
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    public static void disableBlitting(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "disableBlitting"));
        }
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/util/DiffUtil", "scrollToPoint"));
        }
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            Point point = new Point(0, 0);
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
            }
            return point;
        }
        ScrollingModel model = editor.getScrollingModel();
        Point point = new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
        }
        return point;
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        LogicalPosition logicalPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCaretPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/util/DiffUtil", "getArrowIcon"));
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getArrowIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/util/DiffUtil", "getArrowDownIcon"));
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getArrowDownIcon"));
        }
        return icon;
    }

    public static void registerAction(@NotNull AnAction action, @NotNull JComponent component) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/diff/util/DiffUtil", "registerAction"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil", "registerAction"));
        }
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        String text = StringUtil.replace((String)message, (String)"\n", (String)"<br>");
        JBLabel label = new JBLabel(text){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        label.setForeground(UIUtil.getInactiveTextColor());
        CenteredPanel centeredPanel = new CenteredPanel((JComponent)label, JBUI.Borders.empty((int)5));
        if (centeredPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return centeredPanel;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions.length == 0) {
            return;
        }
        if (group.getChildrenCount() != 0) {
            group.addSeparator();
        }
        for (AnAction action : actions) {
            if (action == null) continue;
            group.add(action);
        }
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions == null || actions.isEmpty()) {
            return;
        }
        if (group.getChildrenCount() != 0) {
            group.addSeparator();
        }
        group.addAll(actions);
    }

    @NotNull
    public static String getSettingsConfigurablePath() {
        if ("Settings | Tools | Diff" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSettingsConfigurablePath"));
        }
        return "Settings | Tools | Diff";
    }

    @NotNull
    public static String createTooltipText(@NotNull String text, @Nullable String appendix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "createTooltipText"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><div style='margin-top: 5px'><font size='2'>");
            result2.append(appendix);
            result2.append("</font></div>");
        }
        result2.append("</body></html>");
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTooltipText"));
        }
        return string;
    }

    @NotNull
    public static String createNotificationText(@NotNull String text, @Nullable String appendix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "createNotificationText"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><span style='color:#").append(ColorUtil.toHex((Color)JBColor.gray)).append("'><small>");
            result2.append(appendix);
            result2.append("</small></span>");
        }
        result2.append("</body></html>");
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createNotificationText"));
        }
        return string;
    }

    public static void showSuccessPopup(@NotNull String message, @NotNull RelativePoint point, @NotNull Disposable disposable, final @Nullable Runnable hyperlinkHandler) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/util/DiffUtil", "showSuccessPopup"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/util/DiffUtil", "showSuccessPopup"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/util/DiffUtil", "showSuccessPopup"));
        }
        HyperlinkAdapter listener2 = null;
        if (hyperlinkHandler != null) {
            listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    hyperlinkHandler.run();
                }
            };
        }
        Color bgColor = MessageType.INFO.getPopupBackground();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, bgColor, (HyperlinkListener)listener2).setAnimationCycle(200).createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable, (Disposable)balloon);
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        List contents = request.getContents();
        List titles = request.getContentTitles();
        if (!ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list = Collections.nCopies(titles.size(), null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
            }
            return list;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        for (int i = 0; i < contents.size(); ++i) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i))));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i));
            components.add(title);
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request, @NotNull List<? extends Editor> editors) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        List contents = request.getContents();
        List titles = request.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && !ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list = Collections.nCopies(titles.size(), null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
            }
            return list;
        }
        for (int i = 0; i < contents.size(); ++i) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i))), (DiffContent)contents.get(i), equalCharsets, equalSeparators, editors.get(i));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i));
            result2.add(title);
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        return arrayList;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@Nullable JComponent title, @NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createTitleWithNotifications"));
        }
        List<JComponent> notifications = DiffUtil.getCustomNotifications(content);
        if (notifications.isEmpty()) {
            return title;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        if (title != null) {
            components.add(title);
        }
        components.addAll(notifications);
        return DiffUtil.createStackedComponents(components, TITLE_GAP);
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content instanceof EmptyContent) {
            return null;
        }
        Charset charset = equalCharsets ? null : ((DocumentContent)content).getCharset();
        LineSeparator separator = equalSeparators ? null : ((DocumentContent)content).getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, charset, separator, isReadOnly);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        JComponent jComponent = DiffUtil.createTitle(title, null, null, false);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jComponent;
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable Charset charset, @Nullable LineSeparator separator, boolean readOnly) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (readOnly) {
            title = title + " " + DiffBundle.message((String)"diff.content.read.only.content.title.suffix", (Object[])new Object[0]);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
        panel.add((Component)new JBLabel(title).setCopyable(true), "Center");
        if (charset != null && separator != null) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            panel2.add(DiffUtil.createCharsetPanel(charset));
            panel2.add(Box.createRigidArea(new Dimension(4, 0)));
            panel2.add(DiffUtil.createSeparatorPanel(separator));
            panel.add((Component)panel2, "East");
        } else if (charset != null) {
            panel.add((Component)DiffUtil.createCharsetPanel(charset), "East");
        } else if (separator != null) {
            panel.add((Component)DiffUtil.createSeparatorPanel(separator), "East");
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        JLabel label = new JLabel(charset.displayName());
        if (charset.equals(Charset.forName("UTF-8"))) {
            label.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(Charset.forName("ISO-8859-1"))) {
            label.setForeground((Color)JBColor.RED);
        } else {
            label.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        JLabel label = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label.setForeground((Color)color);
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        return jLabel;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
        }
        if (!ContainerUtil.exists(components, (Condition)Condition.NOT_NULL)) {
            List<JComponent> list = components;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
            }
            return list;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i = 0; i < components.size(); ++i) {
            result2.add(new SyncHeightComponent(components, i));
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
        }
        return arrayList;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<JComponent> components, int gap) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil", "createStackedComponents"));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (int i = 0; i < components.size(); ++i) {
            if (i != 0) {
                panel.add(Box.createVerticalStrut(JBUI.scale((int)gap)));
            }
            panel.add(components.get(i));
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createStackedComponents"));
        }
        return jPanel;
    }

    public static boolean isFocusedComponent(@Nullable Component component) {
        return DiffUtil.isFocusedComponent(null, component);
    }

    public static boolean isFocusedComponent(@Nullable Project project2, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        return IdeFocusManager.getInstance((Project)project2).getFocusedDescendantFor(component) != null;
    }

    public static void requestFocus(@Nullable Project project2, @Nullable Component component) {
        if (component == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project2).requestFocus(component, true);
    }

    @NotNull
    public static List<LineFragment> compare(@NotNull DiffRequest request, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull DiffConfig config, @NotNull ProgressIndicator indicator) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        indicator.checkCanceled();
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        List fragments = diffComputer != null ? diffComputer.compute(text1, text2, config.policy, config.innerFragments, indicator) : (config.innerFragments ? ComparisonManager.getInstance().compareLinesInner(text1, text2, config.policy, indicator) : ComparisonManager.getInstance().compareLines(text1, text2, config.policy, indicator));
        indicator.checkCanceled();
        List list = ComparisonManager.getInstance().processBlocks(fragments, text1, text2, config.policy, config.squashFragments, config.trimFragments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        return list;
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset2(), fragment.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/util/DiffUtil", "isChunksEquals"));
        }
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonManager.getInstance().isEquals(chunk1, chunk2, comparisonPolicy);
    }

    @NotNull
    public static <T> int[] getSortedIndexes(@NotNull List<T> values, @NotNull Comparator<T> comparator2) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/diff/util/DiffUtil", "getSortedIndexes"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/diff/util/DiffUtil", "getSortedIndexes"));
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            indexes.add(i);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/diff/util/DiffUtil", "lambda$getSortedIndexes$3"));
            }
            if (comparator2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/diff/util/DiffUtil", "lambda$getSortedIndexes$3"));
            }
            Object val1 = values.get((Integer)indexes.get((int)i1));
            Object val2 = values.get((Integer)indexes.get((int)i2));
            return comparator2.compare(val1, val2);
        });
        int[] nArray = ArrayUtil.toIntArray(indexes);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSortedIndexes"));
        }
        return nArray;
    }

    @NotNull
    public static int[] invertIndexes(@NotNull int[] indexes) {
        if (indexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexes", "com/intellij/diff/util/DiffUtil", "invertIndexes"));
        }
        int[] inverted = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            inverted[indexes[i]] = i;
        }
        if (inverted == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "invertIndexes"));
        }
        return inverted;
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        Document document2 = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document2);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.hasSelection()) {
                int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
                int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
                lines.set(line1, line2 + 1);
                if (caret.getSelectionEnd() != document2.getTextLength()) continue;
                lines.set(totalLines);
                continue;
            }
            lines.set(caret.getLogicalPosition().line);
            if (caret.getOffset() != document2.getTextLength()) continue;
            lines.set(totalLines);
        }
        BitSet bitSet = lines;
        if (bitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        return bitSet;
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/diff/util/DiffUtil", "isSelectedByLine"));
        }
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document2, int line1, int line2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "deleteLines"));
        }
        TextRange range = DiffUtil.getLinesRange(document2, line1, line2);
        int offset1 = range.getStartOffset();
        int offset2 = range.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document2.getTextLength()) {
            ++offset2;
        }
        document2.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document2, int line, @NotNull CharSequence text) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (line == DiffUtil.getLineCount(document2)) {
            document2.insertString(document2.getTextLength(), (CharSequence)("\n" + text));
        } else {
            document2.insertString(document2.getLineStartOffset(line), (CharSequence)(text + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document2, int line1, int line2, @NotNull CharSequence text) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document2, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document2.replaceString(offset1, offset2, text);
    }

    public static void applyModification(@NotNull Document document2, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (newLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLines", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document2, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document2, line1, line2);
        } else {
            DiffUtil.replaceLines(document2, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document2, int line1, int line2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        TextRange otherRange = DiffUtil.getLinesRange(document2, line1, line2);
        CharSequence charSequence = document2.getImmutableCharSequence().subSequence(otherRange.getStartOffset(), otherRange.getEndOffset());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        return charSequence;
    }

    public static TextRange getLinesRange(@NotNull Document document2, int line1, int line2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return DiffUtil.getLinesRange(document2, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document2, int line1, int line2, boolean includeNewline) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < DiffUtil.getLineCount(document2) ? document2.getLineStartOffset(line1) : document2.getTextLength();
            TextRange textRange = new TextRange(lineStartOffset, lineStartOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
            }
            return textRange;
        }
        int startOffset = document2.getLineStartOffset(line1);
        int endOffset = document2.getLineEndOffset(line2 - 1);
        if (includeNewline && endOffset < document2.getTextLength()) {
            ++endOffset;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return textRange;
    }

    public static int getOffset(@NotNull Document document2, int line, int column) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getOffset"));
        }
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document2)) {
            return document2.getTextLength();
        }
        int start = document2.getLineStartOffset(line);
        int end = document2.getLineEndOffset(line);
        return Math.min(start + column, end);
    }

    public static int getLineCount(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLineCount"));
        }
        return Math.max(document2.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        List<String> list = DiffUtil.getLines(document2, 0, DiffUtil.getLineCount(document2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        return list;
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document2, int startLine, int endLine) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        if (startLine < 0 || startLine > endLine || endLine > DiffUtil.getLineCount(document2)) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, document2.getLineCount()));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = startLine; i < endLine; ++i) {
            int start = document2.getLineStartOffset(i);
            int end = document2.getLineEndOffset(i);
            result2.add(document2.getText(new TextRange(start, end)));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        return arrayList;
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/util/DiffUtil", "getAffectedLineRange"));
        }
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        LineRange lineRange = new LineRange(line1, line2);
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getAffectedLineRange"));
        }
        return lineRange;
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/util/DiffUtil", "countLinesShift"));
        }
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift) {
        UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, shift, false);
        if (updatedLineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
        }
        return updatedLineRange;
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start, end, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start + shift, end + shift, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start <= changeStart && end >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start, end + shift, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        int newChangeEnd = changeEnd + shift;
        if (start >= changeStart && end <= changeEnd) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start < changeStart) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(start, newChangeEnd, true) : new UpdatedLineRange(start, changeStart, true);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
        if (updatedLineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
        }
        return updatedLineRange;
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        TextDiffType textDiffType = DiffUtil.getDiffType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        TextDiffType textDiffType = DiffUtil.getDiffType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            TextDiffType textDiffType = TextDiffType.MODIFIED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
            }
            return textDiffType;
        }
        if (hasDeleted) {
            TextDiffType textDiffType = TextDiffType.DELETED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
            }
            return textDiffType;
        }
        if (hasInserted) {
            TextDiffType textDiffType = TextDiffType.INSERTED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
            }
            return textDiffType;
        }
        LOG.error("Diff fragment should not be empty");
        TextDiffType textDiffType = TextDiffType.MODIFIED;
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<ThreeSide> emptiness, @NotNull Equality<ThreeSide> equality) {
        if (emptiness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptiness", "com/intellij/diff/util/DiffUtil", "getMergeType"));
        }
        if (equality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/diff/util/DiffUtil", "getMergeType"));
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, false, true);
                if (mergeConflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
                }
                return mergeConflictType;
            }
            if (isRightEmpty) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, true, false);
                if (mergeConflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
                }
                return mergeConflictType;
            }
            boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            MergeConflictType mergeConflictType = new MergeConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        if (isLeftEmpty && isRightEmpty) {
            MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.DELETED);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        boolean unchangedLeft = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            MergeConflictType mergeConflictType = new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        if (unchangedRight) {
            MergeConflictType mergeConflictType = new MergeConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        MergeConflictType mergeConflictType = new MergeConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
        if (mergeConflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
        }
        return mergeConflictType;
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends Document> documents, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        MergeConflictType mergeConflictType = DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$4"));
            }
            return DiffUtil.isLineMergeIntervalEmpty(fragment, side);
        }), (Equality<ThreeSide>)((Equality)(side1, side2) -> {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            if (documents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            return DiffUtil.compareLineMergeContents(fragment, documents, policy, side1, side2);
        }));
        if (mergeConflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        return mergeConflictType;
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends Document> documents, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (side1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (side2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        Document document1 = (Document)side1.select(documents);
        Document document2 = (Document)side2.select(documents);
        for (int i = 0; i < end1 - start1; ++i) {
            int line1 = start1 + i;
            int line2 = start2 + i;
            CharSequence content1 = DiffUtil.getLinesContent(document1, line1, line1 + 1);
            CharSequence content2 = DiffUtil.getLinesContent(document2, line2, line2 + 1);
            if (ComparisonManager.getInstance().isEquals(content1, content2, policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "isLineMergeIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/DiffUtil", "isLineMergeIntervalEmpty"));
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    public static void executeWriteCommand(@Nullable Project project2, @NotNull Document document2, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @NotNull Runnable task) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (!DiffUtil.makeWritable(project2, document2)) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
            LOG.warn("Document is read-only" + (file2 != null ? ": " + file2.getPresentableName() : ""));
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "lambda$executeWriteCommand$7"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "lambda$executeWriteCommand$7"));
            }
            if (confirmationPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/util/DiffUtil", "lambda$executeWriteCommand$7"));
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (document2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "lambda$null$6"));
                }
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "lambda$null$6"));
                }
                if (underBulkUpdate) {
                    DocumentUtil.executeInBulk(document2, true, task);
                } else {
                    task.run();
                }
            }, commandName, (Object)commandGroupId, confirmationPolicy, document2);
        });
    }

    public static void executeWriteCommand(@NotNull Document document2, @Nullable Project project2, @Nullable String commandName, @NotNull Runnable task) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        DiffUtil.executeWriteCommand(project2, document2, commandName, null, UndoConfirmationPolicy.DEFAULT, false, task);
    }

    public static boolean isEditable(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isEditable"));
        }
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "canMakeWritable"));
        }
        if (document2.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            return !file2.isWritable();
        }
        return false;
    }

    public static boolean makeWritable(@Nullable Project project2, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
        if (file2 == null || !file2.isValid()) {
            return document2.isWritable();
        }
        return DiffUtil.makeWritable(project2, file2) && document2.isWritable();
    }

    public static boolean makeWritable(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(new VirtualFile[]{file2}).hasReadonlyFiles();
    }

    public static void putNonundoableOperation(@Nullable Project project2, @NotNull Document document2) {
        UndoManager undoManager;
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "putNonundoableOperation"));
        }
        UndoManager undoManager2 = undoManager = project2 != null ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document2);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/diff/util/DiffUtil", "markDirtyAndRefresh"));
        }
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        Dimension dimension = new Dimension(400, 200);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffPanelSize"));
        }
        return dimension;
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        Dimension dimension = new Dimension(width, height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffWindowSize"));
        }
        return dimension;
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        WindowWrapper.Mode mode = hints.getMode();
        if (mode == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        if (window == null) {
            return;
        }
        Container component = window;
        while (component != null) {
            if (component instanceof Window) {
                DiffUtil.closeWindow(component, modalOnly);
            }
            component = recursive ? component.getParent() : null;
        }
    }

    public static void closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/diff/util/DiffUtil", "closeWindow"));
        }
        if (window instanceof IdeFrameImpl) {
            return;
        }
        if (modalOnly && window instanceof Frame) {
            return;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return;
        }
        window.setVisible(false);
        window.dispose();
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key2, @Nullable T value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "createUserDataHolder"));
        }
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key2, value);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key2, UserDataHolder ... holders) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "isUserDataFlagSet"));
        }
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key2)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key2) {
        Object data;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "getUserData"));
        }
        if (first != null && (data = first.getUserData(key2)) != null) {
            return (T)data;
        }
        if (second != null && (data = second.getUserData(key2)) != null) {
            return (T)data;
        }
        return null;
    }

    public static void addNotification(@Nullable JComponent component, @NotNull UserDataHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/diff/util/DiffUtil", "addNotification"));
        }
        if (component == null) {
            return;
        }
        List oldComponents = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, (Object)ContainerUtil.append((List)oldComponents, (Object[])new JComponent[]{component}));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        List requestComponents = (List)request.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List contextComponents = (List)context.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List list = ContainerUtil.concat((List)ContainerUtil.notNullize((List)contextComponents), (List)ContainerUtil.notNullize((List)requestComponents));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        return list;
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        List list = ContainerUtil.notNullize((List)((List)content.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull ContentDiffRequest request, @NotNull Side currentSide) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        if (currentSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSide", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        List contents = request.getContents();
        DiffContent content1 = (DiffContent)currentSide.select(contents);
        DiffContent content2 = (DiffContent)currentSide.other().select(contents);
        if (content1 instanceof FileContent) {
            return ((FileContent)content1).getFile();
        }
        if (content2 instanceof FileContent) {
            return ((FileContent)content2).getFile();
        }
        return null;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull ContentDiffRequest request, @NotNull ThreeSide currentSide) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        if (currentSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSide", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        List contents = request.getContents();
        DiffContent content1 = (DiffContent)currentSide.select(contents);
        DiffContent content2 = (DiffContent)ThreeSide.BASE.select(contents);
        if (content1 instanceof FileContent) {
            return ((FileContent)content1).getFile();
        }
        if (content2 instanceof FileContent) {
            return ((FileContent)content2).getFile();
        }
        return null;
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider, @Nullable DataProvider fallbackProvider, @NonNls String dataId) {
        Object data;
        if (provider != null && (data = provider.getData(dataId)) != null) {
            return data;
        }
        if (fallbackProvider != null && (data = fallbackProvider.getData(dataId)) != null) {
            return data;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key2, @Nullable T value) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/diff/util/DiffUtil", "putDataKey"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "putDataKey"));
        }
        DataProvider dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER);
        if (!(dataProvider instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key2, value);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/util/DiffUtil", "getDiffSettings"));
        }
        DiffSettingsHolder.DiffSettings settings = (DiffSettingsHolder.DiffSettings)context.getUserData(DiffSettingsHolder.KEY);
        if (settings == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(DiffSettingsHolder.KEY, (Object)settings);
        }
        DiffSettingsHolder.DiffSettings diffSettings = settings;
        if (diffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffSettings"));
        }
        return diffSettings;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        if (tools.size() < 2) {
            List list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        List list = filteredTools.isEmpty() ? tools : filteredTools;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        return list;
    }

    public static class CenteredPanel
    extends JPanel {
        private final JComponent myComponent;

        public CenteredPanel(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil$CenteredPanel", "<init>"));
            }
            this.myComponent = component;
            this.add(component);
        }

        public CenteredPanel(@NotNull JComponent component, @NotNull Border border) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil$CenteredPanel", "<init>"));
            }
            if (border == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "border", "com/intellij/diff/util/DiffUtil$CenteredPanel", "<init>"));
            }
            this(component);
            this.setBorder(border);
        }

        @Override
        public void doLayout() {
            Dimension size = this.getSize();
            Dimension preferredSize = this.myComponent.getPreferredSize();
            Insets insets = this.getInsets();
            JBInsets.removeFrom((Dimension)size, (Insets)insets);
            int width = Math.min(size.width, preferredSize.width);
            int height = Math.min(size.height, preferredSize.height);
            int x = Math.max(0, (size.width - preferredSize.width) / 2);
            int y = Math.max(0, (size.height - preferredSize.height) / 2);
            this.myComponent.setBounds(insets.left + x, insets.top + y, width, height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myComponent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myComponent.getMinimumSize());
        }

        @Override
        public Dimension getMaximumSize() {
            return this.addInsets(this.myComponent.getMaximumSize());
        }

        private Dimension addInsets(Dimension dimension) {
            JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
            return dimension;
        }
    }

    private static class SyncHeightComponent
    extends JPanel {
        @NotNull
        private final List<JComponent> myComponents;

        public SyncHeightComponent(@NotNull List<JComponent> components, int index) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil$SyncHeightComponent", "<init>"));
            }
            super(new BorderLayout());
            this.myComponents = components;
            JComponent delegate = components.get(index);
            if (delegate != null) {
                this.add((Component)delegate, "Center");
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getPreferredHeight();
            return size;
        }

        private int getPreferredHeight() {
            int height = 0;
            for (JComponent component : this.myComponents) {
                if (component == null) continue;
                height = Math.max(height, component.getPreferredSize().height);
            }
            return height;
        }
    }

    public static class DiffConfig {
        @NotNull
        public final ComparisonPolicy policy;
        public final boolean innerFragments;
        public final boolean squashFragments;
        public final boolean trimFragments;

        public DiffConfig(@NotNull ComparisonPolicy policy, boolean innerFragments, boolean squashFragments, boolean trimFragments) {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            this.policy = policy;
            this.innerFragments = innerFragments;
            this.squashFragments = squashFragments;
            this.trimFragments = trimFragments;
        }

        public DiffConfig(@NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy) {
            if (ignorePolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            if (highlightPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            this(ignorePolicy.getComparisonPolicy(), highlightPolicy.isFineFragments(), highlightPolicy.isShouldSquash(), ignorePolicy.isShouldTrimChunks());
        }
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

