/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchActionGroupPopup
extends PopupFactoryImpl.ActionGroupPopup {
    public BranchActionGroupPopup(@NotNull String title, @NotNull Project project2, @NotNull Condition<AnAction> preselectActionCondition, @NotNull ActionGroup actions) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (preselectActionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectActionCondition", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        super(title, actions, SimpleDataContext.getProjectContext(project2), false, false, true, false, null, -1, preselectActionCondition, null);
    }

    @Override
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        WizardPopup popup = super.createPopup(parent, step, parentValue);
        RootAction rootAction = BranchActionGroupPopup.getRootAction(parentValue);
        if (rootAction != null) {
            popup.setAdText(rootAction.getCaption());
        }
        return popup;
    }

    @Nullable
    private static RootAction getRootAction(Object value) {
        AnAction action;
        if (value instanceof PopupFactoryImpl.ActionItem && (action = ((PopupFactoryImpl.ActionItem)value).getAction()) instanceof RootAction) {
            return (RootAction)action;
        }
        return null;
    }

    @Override
    protected ListCellRenderer getListElementRenderer() {
        return new PopupListElementRenderer(this){
            private ErrorLabel myBranchLabel;

            @Override
            protected void customizeComponent(JList list, Object value, boolean isSelected) {
                super.customizeComponent(list, value, isSelected);
                RootAction rootAction = BranchActionGroupPopup.getRootAction(value);
                if (rootAction != null) {
                    this.myBranchLabel.setVisible(true);
                    this.myBranchLabel.setText(String.format("[%s]", rootAction.getDisplayableBranchText()));
                    if (isSelected) {
                        this.setSelected((JComponent)this.myBranchLabel);
                    } else {
                        this.myBranchLabel.setBackground(this.getBackground());
                        this.myBranchLabel.setForeground((Color)JBColor.GRAY);
                    }
                } else {
                    this.myBranchLabel.setVisible(false);
                }
            }

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder(JBUI.Borders.empty((int)1));
                this.myBranchLabel = new ErrorLabel();
                this.myBranchLabel.setOpaque(true);
                this.myBranchLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)1, (int)1));
                OpaquePanel compoundPanel = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)JBColor.WHITE);
                compoundPanel.add((Component)this.myTextLabel, "Center");
                compoundPanel.add((Component)this.myBranchLabel, "East");
                return this.layoutComponent((JComponent)compoundPanel);
            }
        };
    }
}

