/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaTestLocator
implements SMTestLocator {
    public static final String SUITE_PROTOCOL = "java:suite";
    public static final String TEST_PROTOCOL = "java:test";
    public static final JavaTestLocator INSTANCE = new JavaTestLocator();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        String className;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/JavaTestLocator", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/JavaTestLocator", "getLocation"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/JavaTestLocator", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/JavaTestLocator", "getLocation"));
        }
        List results = Collections.emptyList();
        String paramName = null;
        int idx = path.indexOf(91);
        if (idx >= 0) {
            paramName = path.substring(idx);
            path = path.substring(0, idx);
        }
        if (SUITE_PROTOCOL.equals(protocol)) {
            path = StringUtil.trimEnd((String)path, (String)".");
            PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)path, null, (boolean)true, (GlobalSearchScope)scope);
            if (aClass != null) {
                results = ContainerUtil.newSmartList();
                results.add(paramName != null ? PsiMemberParameterizedLocation.getParameterizedLocation(aClass, paramName) : new PsiLocation(project2, (PsiElement)aClass));
            }
        } else if (TEST_PROTOCOL.equals(protocol) && !StringUtil.isEmpty((String)(className = StringUtil.getPackageName((String)path)))) {
            String methodName = StringUtil.getShortName((String)path);
            PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)className, null, (boolean)true, (GlobalSearchScope)scope);
            if (aClass != null) {
                results = ContainerUtil.newSmartList();
                PsiMethod[] methods = aClass.findMethodsByName(methodName.trim(), true);
                if (methods.length > 0) {
                    for (PsiMethod method : methods) {
                        results.add(paramName != null ? new PsiMemberParameterizedLocation(project2, (PsiElement)method, aClass, paramName) : MethodLocation.elementInClass(method, aClass));
                    }
                }
            }
        }
        List list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/JavaTestLocator", "getLocation"));
        }
        return list;
    }
}

