/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Attribute;

@com.intellij.openapi.components.State(name="ExportTestResults", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExportTestResultsConfiguration
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static ExportTestResultsConfiguration getInstance(Project project2) {
        return (ExportTestResultsConfiguration)ServiceManager.getService((Project)project2, ExportTestResultsConfiguration.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public String getOutputFolder() {
        return this.myState.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.myState.outputFolder = outputFolder;
    }

    public boolean isOpenResults() {
        return this.myState.openResultsInEditor;
    }

    public void setOpenResults(boolean openResultsInEditor) {
        this.myState.openResultsInEditor = openResultsInEditor;
    }

    public ExportFormat getExportFormat() {
        return this.myState.myExportFormat;
    }

    public void setExportFormat(ExportFormat exportFormat) {
        this.myState.myExportFormat = exportFormat;
    }

    public String getUserTemplatePath() {
        return this.myState.userTemplatePath;
    }

    public void setUserTemplatePath(String userTemplatePath) {
        this.myState.userTemplatePath = userTemplatePath;
    }

    public static class State {
        @Attribute(value="outputFolder")
        public String outputFolder;
        @Attribute(value="openResultsInEditor")
        public boolean openResultsInEditor;
        @Attribute(value="userTempatePath")
        public String userTemplatePath;
        private ExportFormat myExportFormat = ExportFormat.BundledTemplate;

        @Attribute(value="exportFormat")
        public String getExportFormat() {
            return this.myExportFormat.name();
        }

        public void setExportFormat(String exportFormat) {
            try {
                this.myExportFormat = ExportFormat.valueOf(exportFormat);
            }
            catch (IllegalArgumentException e) {
                this.myExportFormat = ExportFormat.BundledTemplate;
            }
        }
    }

    public static enum ExportFormat {
        Xml("xml"),
        BundledTemplate("html"),
        UserTemplate("html");

        private final String myExtension;

        private ExportFormat(String extension) {
            this.myExtension = extension;
        }

        public String getDefaultExtension() {
            return this.myExtension;
        }
    }
}

