/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class FacetDependentToolWindowManager
extends AbstractProjectComponent {
    private final ProjectWideFacetListenersRegistry myFacetListenersRegistry;
    private final ProjectFacetManager myFacetManager;
    private final ToolWindowManagerEx myToolWindowManager;

    protected FacetDependentToolWindowManager(Project project2, ProjectWideFacetListenersRegistry facetListenersRegistry, ProjectFacetManager facetManager, ToolWindowManagerEx toolWindowManager) {
        super(project2);
        this.myFacetListenersRegistry = facetListenersRegistry;
        this.myFacetManager = facetManager;
        this.myToolWindowManager = toolWindowManager;
    }

    public void projectOpened() {
        FacetDependentToolWindow[] extensions;
        this.myFacetListenersRegistry.registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(Facet facet) {
                for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    FacetDependentToolWindowManager.this.ensureToolWindowExists(extension);
                }
            }

            public void facetRemoved(Facet facet) {
                if (!FacetDependentToolWindowManager.this.myFacetManager.hasFacets(facet.getTypeId())) {
                    for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                        ToolWindow toolWindow = FacetDependentToolWindowManager.this.myToolWindowManager.getToolWindow(extension.id);
                        if (toolWindow == null) continue;
                        List facetTypes = extension.getFacetTypes();
                        for (FacetType facetType : facetTypes) {
                            if (!FacetDependentToolWindowManager.this.myFacetManager.hasFacets(facetType.getId())) continue;
                            return;
                        }
                        FacetDependentToolWindowManager.this.myToolWindowManager.unregisterToolWindow(extension.id);
                    }
                }
            }
        }, (Disposable)this.myProject);
        block0: for (FacetDependentToolWindow extension : extensions = (FacetDependentToolWindow[])Extensions.getExtensions((ExtensionPointName)FacetDependentToolWindow.EXTENSION_POINT_NAME)) {
            for (FacetType type : extension.getFacetTypes()) {
                if (!this.myFacetManager.hasFacets(type.getId())) continue;
                this.ensureToolWindowExists(extension);
                continue block0;
            }
        }
    }

    private void ensureToolWindowExists(FacetDependentToolWindow extension) {
        ToolWindow toolWindow = this.myToolWindowManager.getToolWindow(extension.id);
        if (toolWindow == null) {
            this.myToolWindowManager.initToolWindow((ToolWindowEP)extension);
        }
    }

    private static List<FacetDependentToolWindow> getDependentExtensions(Facet facet) {
        Object[] extensions = (FacetDependentToolWindow[])Extensions.getExtensions((ExtensionPointName)FacetDependentToolWindow.EXTENSION_POINT_NAME);
        return ContainerUtil.filter((Object[])extensions, toolWindowEP -> {
            for (String id : toolWindowEP.getFacetIds()) {
                if (!facet.getType().getStringId().equals(id)) continue;
                return true;
            }
            return false;
        });
    }
}

