/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandler;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private final JavaClassFindUsagesOptions myFindClassOptions;
    private final JavaMethodFindUsagesOptions myFindMethodOptions;
    private final JavaPackageFindUsagesOptions myFindPackageOptions;
    private final JavaThrowFindUsagesOptions myFindThrowOptions;
    private final JavaVariableFindUsagesOptions myFindVariableOptions;

    public static JavaFindUsagesHandlerFactory getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "getInstance"));
        }
        return (JavaFindUsagesHandlerFactory)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)EP_NAME, (AreaInstance)project2), JavaFindUsagesHandlerFactory.class);
    }

    public JavaFindUsagesHandlerFactory(Project project2) {
        this.myFindClassOptions = new JavaClassFindUsagesOptions(project2);
        this.myFindMethodOptions = new JavaMethodFindUsagesOptions(project2);
        this.myFindPackageOptions = new JavaPackageFindUsagesOptions(project2);
        this.myFindThrowOptions = new JavaThrowFindUsagesOptions(project2);
        this.myFindVariableOptions = new JavaVariableFindUsagesOptions(project2);
    }

    @Override
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "canFindUsages"));
        }
        return new JavaFindUsagesProvider().canFindUsagesFor(element);
    }

    @Override
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage == null ? null : new JavaFindUsagesHandler((PsiElement)psiPackage, this);
        }
        if (element instanceof PsiMethod && !forHighlightUsages) {
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)element, JavaFindUsagesHandler.ACTION_STRING);
            if (methods.length > 1) {
                return new JavaFindUsagesHandler(element, (PsiElement[])methods, this);
            }
            if (methods.length == 1) {
                return new JavaFindUsagesHandler((PsiElement)methods[0], this);
            }
            return FindUsagesHandler.NULL_HANDLER;
        }
        return new JavaFindUsagesHandler(element, this);
    }

    @NotNull
    public JavaClassFindUsagesOptions getFindClassOptions() {
        JavaClassFindUsagesOptions javaClassFindUsagesOptions = this.myFindClassOptions;
        if (javaClassFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "getFindClassOptions"));
        }
        return javaClassFindUsagesOptions;
    }

    @NotNull
    public JavaMethodFindUsagesOptions getFindMethodOptions() {
        JavaMethodFindUsagesOptions javaMethodFindUsagesOptions = this.myFindMethodOptions;
        if (javaMethodFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "getFindMethodOptions"));
        }
        return javaMethodFindUsagesOptions;
    }

    @NotNull
    public JavaPackageFindUsagesOptions getFindPackageOptions() {
        JavaPackageFindUsagesOptions javaPackageFindUsagesOptions = this.myFindPackageOptions;
        if (javaPackageFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "getFindPackageOptions"));
        }
        return javaPackageFindUsagesOptions;
    }

    @NotNull
    public JavaThrowFindUsagesOptions getFindThrowOptions() {
        JavaThrowFindUsagesOptions javaThrowFindUsagesOptions = this.myFindThrowOptions;
        if (javaThrowFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "getFindThrowOptions"));
        }
        return javaThrowFindUsagesOptions;
    }

    @NotNull
    public JavaVariableFindUsagesOptions getFindVariableOptions() {
        JavaVariableFindUsagesOptions javaVariableFindUsagesOptions = this.myFindVariableOptions;
        if (javaVariableFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory", "getFindVariableOptions"));
        }
        return javaVariableFindUsagesOptions;
    }
}

