/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HtmlLineMarkerProvider
implements LineMarkerProvider {
    private final Map<Language, LineMarkerProvider> embeddedLanguagesLineMarkerProviders = new THashMap();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        LineMarkerProvider markerProvider;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/html/HtmlLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (element instanceof PsiWhiteSpace) {
            return null;
        }
        Language language = element.getLanguage();
        if (!(language instanceof XMLLanguage) && (markerProvider = HtmlLineMarkerProvider.getLineMarkerProviderFromLanguage(language, this.embeddedLanguagesLineMarkerProviders)) != null) {
            return markerProvider.getLineMarkerInfo(element);
        }
        return null;
    }

    private static LineMarkerProvider getLineMarkerProviderFromLanguage(Language language, Map<Language, LineMarkerProvider> embeddedLanguagesLineMarkerProviders) {
        LineMarkerProvider markerProvider;
        if (!embeddedLanguagesLineMarkerProviders.containsKey(language)) {
            markerProvider = (LineMarkerProvider)LineMarkerProviders.INSTANCE.forLanguage(language);
            embeddedLanguagesLineMarkerProviders.put(language, markerProvider);
        } else {
            markerProvider = embeddedLanguagesLineMarkerProviders.get(language);
        }
        return markerProvider;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/html/HtmlLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/html/HtmlLineMarkerProvider", "collectSlowLineMarkers"));
        }
        THashMap localEmbeddedLanguagesLineMarkerProviders = null;
        Map embeddedLineMarkersWorkItems = null;
        for (PsiElement psiElement : elements) {
            ArrayList<PsiElement> elementList;
            LineMarkerProvider lineMarkerProvider;
            Language language;
            if (psiElement instanceof PsiWhiteSpace || (language = psiElement.getLanguage()) instanceof XMLLanguage) continue;
            if (localEmbeddedLanguagesLineMarkerProviders == null) {
                localEmbeddedLanguagesLineMarkerProviders = new THashMap();
            }
            if ((lineMarkerProvider = HtmlLineMarkerProvider.getLineMarkerProviderFromLanguage(language, localEmbeddedLanguagesLineMarkerProviders)) == null) continue;
            if (embeddedLineMarkersWorkItems == null) {
                embeddedLineMarkersWorkItems = new THashMap();
            }
            if ((elementList = (ArrayList<PsiElement>)embeddedLineMarkersWorkItems.get(lineMarkerProvider)) == null) {
                elementList = new ArrayList<PsiElement>(5);
                embeddedLineMarkersWorkItems.put(lineMarkerProvider, elementList);
            }
            elementList.add(psiElement);
        }
        if (embeddedLineMarkersWorkItems != null) {
            for (Map.Entry entry : embeddedLineMarkersWorkItems.entrySet()) {
                ((LineMarkerProvider)entry.getKey()).collectSlowLineMarkers((List)entry.getValue(), result2);
            }
        }
    }
}

