/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CopyPasteDelegator
implements CopyPasteSupport {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.filePasteProvider");
    public static final Key<Boolean> SHOW_CHOOSER_KEY = Key.create((String)"show.dirs.chooser");
    private final Project myProject;
    private final JComponent myKeyReceiver;
    private final MyEditable myEditable;

    public CopyPasteDelegator(Project project2, JComponent keyReceiver) {
        this.myProject = project2;
        this.myKeyReceiver = keyReceiver;
        this.myEditable = new MyEditable();
    }

    @NotNull
    protected abstract PsiElement[] getSelectedElements();

    @NotNull
    private PsiElement[] getValidSelectedElements() {
        PsiElement[] selectedElements;
        for (PsiElement element : selectedElements = this.getSelectedElements()) {
            if (element != null && element.isValid()) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteDelegator", "getValidSelectedElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (selectedElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteDelegator", "getValidSelectedElements"));
        }
        return selectedElements;
    }

    private void updateView() {
        this.myKeyReceiver.repaint();
    }

    public CopyProvider getCopyProvider() {
        return this.myEditable;
    }

    public CutProvider getCutProvider() {
        return this.myEditable;
    }

    public PasteProvider getPasteProvider() {
        return this.myEditable;
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider {
        private MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "performCopy"));
            }
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            PsiCopyPasteManager.getInstance().setElements(elements, true);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "isCopyEnabled"));
            }
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            return CopyHandler.canCopy(elements) || PsiCopyPasteManager.asFileList(elements) != null;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "isCopyVisible"));
            }
            return true;
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "performCut"));
            }
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            if (MoveHandler.adjustForMove(CopyPasteDelegator.this.myProject, elements, null) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(elements, false);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "isCutEnabled"));
            }
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            return elements.length != 0 && MoveHandler.canMove(elements, null);
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "isCutVisible"));
            }
            return true;
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "performPaste"));
            }
            if (!this.performDefaultPaste(dataContext)) {
                for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                    if (!provider.isPasteEnabled(dataContext)) continue;
                    provider.performPaste(dataContext);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean performDefaultPaste(DataContext dataContext) {
            block12: {
                boolean[] isCopied = new boolean[1];
                PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
                if (elements == null) {
                    return false;
                }
                PsiDirectory targetDirectory = null;
                DumbService.getInstance((Project)CopyPasteDelegator.this.myProject).setAlternativeResolveEnabled(true);
                try {
                    PsiDirectory[] directories;
                    PsiElement target = (PsiElement)LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
                    Module module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
                    if (module2 != null && target instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)target).getDirectories(GlobalSearchScope.moduleScope((Module)module2))).length == 1) {
                        target = directories[0];
                    }
                    if (isCopied[0]) {
                        PsiFile containingFile;
                        PsiDirectory psiDirectory = targetDirectory = target instanceof PsiDirectory ? (PsiDirectory)target : null;
                        if (targetDirectory == null && target instanceof PsiDirectoryContainer) {
                            PsiDirectory[] psiDirectoryArray = directories = module2 == null ? ((PsiDirectoryContainer)target).getDirectories() : ((PsiDirectoryContainer)target).getDirectories(GlobalSearchScope.moduleScope((Module)module2));
                            if (directories.length > 0) {
                                targetDirectory = directories[0];
                                targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, (Object)(directories.length > 1 ? 1 : 0));
                            }
                        }
                        if (targetDirectory == null && target != null && (containingFile = target.getContainingFile()) != null) {
                            targetDirectory = containingFile.getContainingDirectory();
                        }
                        if (CopyHandler.canCopy(elements)) {
                            CopyHandler.doCopy(elements, targetDirectory);
                        }
                        break block12;
                    }
                    if (MoveHandler.canMove(elements, target)) {
                        MoveHandler.doMove(CopyPasteDelegator.this.myProject, elements, target, dataContext, new MoveCallback(){

                            @Override
                            public void refactoringCompleted() {
                                PsiCopyPasteManager.getInstance().clear();
                            }
                        });
                        break block12;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    DumbService.getInstance((Project)CopyPasteDelegator.this.myProject).setAlternativeResolveEnabled(false);
                    CopyPasteDelegator.this.updateView();
                    if (targetDirectory != null) {
                        targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, null);
                    }
                }
            }
            return true;
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "isPastePossible"));
            }
            return true;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/CopyPasteDelegator$MyEditable", "isPasteEnabled"));
            }
            if (this.isDefaultPasteEnabled(dataContext)) {
                return true;
            }
            for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                if (!provider.isPasteEnabled(dataContext)) continue;
                return true;
            }
            return false;
        }

        private boolean isDefaultPasteEnabled(DataContext dataContext) {
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return false;
            }
            if (DumbService.isDumb((Project)project2)) {
                return false;
            }
            Object target = LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (target == null) {
                return false;
            }
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(new boolean[]{false});
            if (elements == null) {
                return false;
            }
            for (PsiElement element : elements) {
                PsiManager manager = element.getManager();
                if (manager != null && manager.getProject() == project2) continue;
                return false;
            }
            return true;
        }
    }
}

