/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.DisplayChangeDetector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.User32;

public class RemoteDesktopDetector {
    private static final Logger LOG = Logger.getInstance(RemoteDesktopDetector.class);
    private volatile boolean myFailureDetected;
    private volatile boolean myRemoteDesktopConnected;

    public static RemoteDesktopDetector getInstance() {
        return (RemoteDesktopDetector)ServiceManager.getService(RemoteDesktopDetector.class);
    }

    private RemoteDesktopDetector() {
        if (SystemInfo.isWindows) {
            DisplayChangeDetector.getInstance().addListener(new DisplayChangeDetector.Listener(){

                @Override
                public void displayChanged() {
                    RemoteDesktopDetector.this.updateState();
                }
            });
            this.updateState();
        }
    }

    private void updateState() {
        if (!this.myFailureDetected) {
            try {
                boolean newValue = User32.INSTANCE.GetSystemMetrics(4096) != 0;
                LOG.debug("Detected remote desktop: ", new Object[]{newValue});
                if (newValue != this.myRemoteDesktopConnected) {
                    this.myRemoteDesktopConnected = newValue;
                    if (this.myRemoteDesktopConnected) {
                        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)new Notification("System Messages", ApplicationBundle.message((String)"remote.desktop.detected.title", (Object[])new Object[0]), ApplicationBundle.message((String)"remote.desktop.detected.message", (Object[])new Object[0]), NotificationType.INFORMATION)));
                    }
                }
            }
            catch (Throwable e) {
                this.myRemoteDesktopConnected = false;
                this.myFailureDetected = true;
                LOG.warn("Error while calling GetSystemMetrics", e);
            }
        }
    }

    public boolean isRemoteDesktopConnected() {
        return this.myRemoteDesktopConnected;
    }

    public static boolean isRemoteSession() {
        return RemoteDesktopDetector.getInstance().isRemoteDesktopConnected();
    }
}

