/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.projectImport.ProjectAttachProcessor;

public class CloseProjectAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        ProjectUtil.closeAndDispose(project2);
        WelcomeFrame.showIfNoProjectOpened();
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        presentation.setEnabled(project2 != null);
        if (ProjectAttachProcessor.canAttachToProject() && project2 != null && ModuleManager.getInstance((Project)project2).getModules().length > 1) {
            presentation.setText("Close Pro_jects in Current Window");
        } else {
            presentation.setText("Close Pro_ject");
        }
    }
}

