/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeLookAndFeel
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeLookAndFeel", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeLookAndFeel", "fillActions"));
        }
        final LafManager lafMan = LafManager.getInstance();
        UIManager.LookAndFeelInfo[] lfs = lafMan.getInstalledLookAndFeels();
        UIManager.LookAndFeelInfo current = lafMan.getCurrentLookAndFeel();
        for (final UIManager.LookAndFeelInfo lf : lfs) {
            group.add((AnAction)new DumbAwareAction(lf.getName(), "", lf == current ? ourCurrentAction : ourNotCurrentAction){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(AnActionEvent e) {
                    UIManager.LookAndFeelInfo cur = lafMan.getCurrentLookAndFeel();
                    if (cur == lf) {
                        return;
                    }
                    boolean wasDarcula = UIUtil.isUnderDarcula();
                    lafMan.setCurrentLookAndFeel(lf);
                    AtomicBoolean updated = new AtomicBoolean(false);
                    LafManagerListener listener2 = s -> updated.set(true);
                    lafMan.addLafManagerListener(listener2);
                    try {
                        if (UIUtil.isUnderDarcula()) {
                            DarculaInstaller.install();
                        } else if (wasDarcula) {
                            DarculaInstaller.uninstall();
                        }
                    }
                    finally {
                        lafMan.removeLafManagerListener(listener2);
                        if (!updated.get()) {
                            lafMan.updateUI();
                        }
                    }
                }
            });
        }
    }

    protected boolean isEnabled() {
        return LafManager.getInstance().getInstalledLookAndFeels().length > 1;
    }
}

